#!/bin/bash

if [ -z ${1} ]
then
  echo "USAGE: $0 File1 File2"
  exit 1
fi
if [ -z ${2} ]
then
  echo "USAGE: $0 File1 File2"
  exit 1
fi

File1=${1}
File2=${2}
gnuplot -e "set terminal postscript eps color;\
 set output 'PlotVES.eps';\
 set logscale x 10;\
 set xrange [1:10000];\
 set xlabel 'MN/2 [m]';\
 set logscale y 10;\
 set yrange [1:1000];\
 set ylabel '{/Symbol r}_s [{/Symbol W}{/Symbol \327}m]';\
 set grid;\
 plot '${File1}' title 'Messwerte' with point linecolor rgb '#000000', '${File2}' title 'Modellierung' with lines linecolor rgb '#dd181f'; "
gv PlotVES.eps 2>/dev/null
