# import the standard toolbox needed
from mpl_toolkits.basemap import Basemap
import matplotlib.pyplot as plt
import matplotlib.mlab as mlab
import numpy as np


#=============================================================
# a ) Plot the reference geoid:

# Read in the data using np.loadtxt() 
geopath = './RefGeo'
lon_lat_geo = np.loadtxt(geopath)

# Call a Basemap mollweid projection
m=Basemap(projection='moll',lat_0=0,lon_0=0,resolution='i')

# Set the suitable latitudes and longitudes
tran_lons = np.linspace(-180, +180, 361)
tran_lats = np.linspace(-90, 90, 181)

lon,lat=np.meshgrid(tran_lons,tran_lats)
nat_lon, nat_lat = m(lon, lat)

geo_grd = mlab.griddata(lon_lat_geo[:,0],lon_lat_geo[:,1],\
   lon_lat_geo[:,2],tran_lons,tran_lats,interp='linear')

# Plot the regular meshed data with the native longitude and latitude
# Making the contour
calvs = np.linspace(-120,+120,25)
img = m.contourf(nat_lon,nat_lat,geo_grd,calvs)

# Draw the coastlines and borderlines
m.drawcoastlines(linewidth=0.25)
m.drawcountries(linewidth=0.25)

plt.savefig('exampleA.png')
cb = m.colorbar(img,'right', size='5%', pad="5%")
plt.show()

#=============================================================
# b) To plot several files we could define a class which provides
#     different functions for us
# import defined class from basemap_tool
from basemap_tool import *
# b-a)
# We give a temperature file extracted from a terra simulation as data
temp_path = './t721.0045.05_06'
geog_plot(fileadd=temp_path,titletxt='Temperature file of Terra',\
         colorlabel='Deviation[%]',show_fg=True, save_fg=False,agenum=0,\
         coast_plot=True,palletcolor='jet');
## b-b)
temp_path = './t721.0045.00_06'
# For plotting a temperature file of a different age, and saving it with in ./
geog_plot(fileadd=temp_path,titletxt='Temperature file of Terra',\
      colorlabel='Deviation[%]',show_fg=False, save_fg=True,agenum=50,\
      coast_plot=True, fileout='./exampleB');

