#!/bin/bash

# GMT wrapper script?
gmt=$(which GMT)

# allgemeine Angaben fuer GMT
$gmt gmtset HEADER_FONT_SIZE 12p
$gmt gmtset ANOT_FONT_SIZE 8p
$gmt gmtset LABEL_FONT_SIZE 10p
$gmt gmtset GRID_PEN 0.25pta
$gmt gmtset PAPER_MEDIA A4+

#-----------------------------------------------------
#--------20.9 kHz-------------------------------------
#-----------------------------------------------------

# Farbpalette erzeugen -- In-Phase
$gmt makecpt -Cpolar -T-55/55/10 -Z > InPhase.cpt
# erstes vlf-Bild erzeugen -- In-Phase
$gmt xyz2grd 20_9in.txt -I2/1 -G20_9-1.grd -R8/22/0/30 
# Daten zeichnen
$gmt grdimage 20_9-1.grd -K -P -Jx0.4 -R8/22/0/30 -CInPhase.cpt -Bf1a2g4:"x [m]":/f1a2g4:"y [m]":WeSn:."In-Phase 20.9 kHz": > vlf-in-20.eps
$gmt grdcontour 20_9-1.grd -O -K -P -Jx0.4 -R8/22/0/30 -C10 -A20f8 >> vlf-in-20.eps
# Rand des Erzganges einzeichnen
$gmt psxy untenlinks.xy obenrechts.xy -Jx0.4 -R -K -O -W2p/0/200/000 >> vlf-in-20.eps
# Beschriftung des Randes
echo "12 20 10 0 4 BL - Erzgang "| $gmt pstext -R -Jx0.4 -O -K -G0/200/0 -W255/255/255O -N >> vlf-in-20.eps
# Skala einbringen
$gmt psscale -O -P -D7/5/6/1 -CInPhase.cpt -Bf5a10::/:"H@-z@-/H@-y@- [%]": >> vlf-in-20.eps


# Farbpalette erzeugen -- Gradient In-Phase
$gmt makecpt -Cpolar -T-20/20/1 -Z > GInPhase.cpt
# Gradienten In-Phase erzeugen
$gmt grdgradient 20_9-1.grd -G20_9-2.grd -A45
# Daten zeichnen
$gmt grdimage 20_9-2.grd -K -P -Jx0.4 -R8/22/0/30 -CGInPhase.cpt -Bf1a2g4:"x [m]":/f1a2g4:"y [m]":WeSn:."Gradient In-Phase 20.9 kHz": > vlf-gin-20.eps
$gmt grdcontour 20_9-2.grd -O -K -P -Jx0.4 -R8/22/0/30 -C5 -A5f8 >> vlf-gin-20.eps
# Rand des Erzganges einzeichnen
$gmt psxy untenlinks.xy obenrechts.xy -Jx0.4 -R -K -O -W2p/0/200/000 >> vlf-gin-20.eps
# Beschriftung des Randes
echo "12 20 10 0 4 BL - Erzgang "| $gmt pstext -R -Jx0.4 -O -K -G0/200/0 -W255/255/255O -N >> vlf-gin-20.eps
# Skala einbringen
$gmt psscale -O -P -D7/5/6/1 -CGInPhase.cpt -Bf5a5::/:"H@-z@-/H@-y@- [%]": >> vlf-gin-20.eps

# Farbpalette erzeugen -- Out-Phase
$gmt makecpt -Cpolar -T-30/55/10 -Z > OutPhase.cpt
# zweites vlf-Bild erzeugen -- Out-Phase
$gmt xyz2grd 20_9q.txt -I2/1 -G20_9-1.grd -R8/22/0/30 
# Daten zeichnen
$gmt grdimage 20_9-1.grd -K -P -Jx0.4 -R8/22/0/30 -COutPhase.cpt -Bf1a2g4:"x [m]":/f1a2g4:"y [m]":WeSn:."Out-Phase 20.9 kHz": > vlf-out-20.eps
$gmt grdcontour 20_9-1.grd -O -K -P -Jx0.4 -R8/22/0/30 -C10 -A20f8 >> vlf-out-20.eps
# Rand des Erzganges einzeichnen
$gmt psxy untenlinks.xy obenrechts.xy -Jx0.4 -R -K -O -W2p/0/200/000 >> vlf-out-20.eps
# Beschriftung des Randes
echo "12 20 10 0 4 BL - Erzgang "| $gmt pstext -R -Jx0.4 -O -K -G0/200/0 -W255/255/255O -N >> vlf-out-20.eps
# Skala einbringen
$gmt psscale -O -P -D7/5/6/1 -COutPhase.cpt -Bf5a10::/:"H@-z@-/H@-y@- [%]": >> vlf-out-20.eps

# Farbpalette erzeugen -- Gradient Out-Phase
$gmt makecpt -Cpolar -T-20/20/1 -Z > GOutPhase.cpt
# Gradienten Out-Phase erzeugen
$gmt grdgradient 20_9-1.grd -G20_9-2.grd -A45
# Daten zeichnen
$gmt grdimage 20_9-2.grd -K -P -Jx0.4 -R8/22/0/30 -CGOutPhase.cpt -Bf1a2g4:"x [m]":/f1a2g4:"y [m]":WeSn:."Gradient Out-Phase 20.9 kHz": > vlf-gout-20.eps
$gmt grdcontour 20_9-2.grd -O -K -P -Jx0.4 -R8/22/0/30 -C5 -A5f8 >> vlf-gout-20.eps
# Rand des Erzganges einzeichnen
$gmt psxy untenlinks.xy obenrechts.xy -Jx0.4 -R -K -O -W2p/0/200/000 >> vlf-gout-20.eps
# Beschriftung des Randes
echo "12 20 10 0 4 BL - Erzgang "| $gmt pstext -R -Jx0.4 -O -K -G0/200/0 -W255/255/255O -N >> vlf-gout-20.eps
# Skala einbringen
$gmt psscale -O -P -D7/5/6/1 -CGOutPhase.cpt -Bf5a5::/:"H@-z@-/H@-y@- [%]": >> vlf-gout-20.eps

#-----------------------------------------------------
#--------23.3 kHz-------------------------------------
#-----------------------------------------------------

# Farbpalette erzeugen -- In-Phase
$gmt makecpt -Cpolar -T-55/55/10 -Z > InPhase.cpt
# erstes vlf-Bild erzeugen -- In-Phase
$gmt xyz2grd 23_3in.txt -I2/1 -G23_3-1.grd -R8/22/0/30 
# Daten zeichnen
$gmt grdimage 23_3-1.grd -K -P -Jx0.4 -R8/22/0/30 -CInPhase.cpt -Bf1a2g4:"x [m]":/f1a2g4:"y [m]":WeSn:."In-Phase 23.3 kHz": > vlf-in-23.eps
$gmt grdcontour 23_3-1.grd -O -K -P -Jx0.4 -R8/22/0/30 -C10 -A20f8 >> vlf-in-23.eps
# Rand des Erzganges einzeichnen
$gmt psxy links.xy rechts.xy obenrechts.xy -Jx0.4 -R -K -O -W2p/0/200/000 >> vlf-in-23.eps
# Beschriftung des Randes
echo "12 20 10 0 4 BL - Erzgang "| $gmt pstext -R -Jx0.4 -O -K -G0/200/0 -W255/255/255O -N >> vlf-in-23.eps
# Skala einbringen
$gmt psscale -O -P -D7/5/6/1 -CInPhase.cpt -Bf5a10::/:"H@-z@-/H@-y@- [%]": >> vlf-in-23.eps

# Farbpalette erzeugen -- Gradient In-Phase
$gmt makecpt -Cpolar -T-15/30/1 -Z > GInPhase.cpt
# Gradienten In-Phase erzeugen
$gmt grdgradient 23_3-1.grd -G23_3-2.grd -A90
# Daten zeichnen
$gmt grdimage 23_3-2.grd -K -P -Jx0.4 -R8/22/0/30 -CGInPhase.cpt -Bf1a2g4:"x [m]":/f1a2g4:"y [m]":WeSn:."Gradient In-Phase 23.3 kHz": > vlf-gin-23.eps
$gmt grdcontour 23_3-2.grd -O -K -P -Jx0.4 -R8/22/0/30 -C5 -A5f8 >> vlf-gin-23.eps
# Rand des Erzganges einzeichnen
$gmt psxy links.xy rechts.xy obenrechts.xy -Jx0.4 -R -K -O -W2p/0/200/000 >> vlf-gin-23.eps
# Beschriftung des Randes
echo "12 20 10 0 4 BL - Erzgang "| $gmt pstext -R -Jx0.4 -O -K -G0/200/0 -W255/255/255O -N >> vlf-gin-23.eps
# Skala einbringen
$gmt psscale -O -P -D7/5/6/1 -CGInPhase.cpt -Bf5a5::/:"H@-z@-/H@-y@- [%]": >> vlf-gin-23.eps

# Farbpalette erzeugen
$gmt makecpt -Cpolar -T-30/55/5 -Z > OutPhase.cpt
# zweites vlf-Bild erzeugen -- Out-Phase
$gmt xyz2grd 23_3q.txt -I2/1 -G23_3-1.grd -R8/22/0/30 
# Daten zeichnen
$gmt grdimage 23_3-1.grd -K -P -Jx0.4 -R8/22/0/30 -COutPhase.cpt -Bf1a2g4:"x [m]":/f1a2g4:"y [m]":WeSn:."Out-Phase 23.3 kHz": > vlf-out-23.eps
$gmt grdcontour 23_3-1.grd -O -K -P -Jx0.4 -R8/22/0/30 -C10 -A20f8 >> vlf-out-23.eps
# Rand des Erzganges einzeichnen
$gmt psxy links.xy rechts.xy obenrechts.xy -Jx0.4 -R -K -O -W2p/0/200/000 >> vlf-out-23.eps
# Beschriftung des Randes
echo "12 20 10 0 4 BL - Erzgang "| $gmt pstext -R -Jx0.4 -O -K -G0/200/0 -W255/255/255O -N >> vlf-out-23.eps
# Skala einbringen
$gmt psscale -O -P -D7/5/6/1 -COutPhase.cpt -Bf5a10::/:"H@-z@-/H@-y@- [%]": >> vlf-out-23.eps

# Farbpalette erzeugen -- Gradient Out-Phase
$gmt makecpt -Cpolar -T-15/30/1 -Z > GOutPhase.cpt
# Gradienten Out-Phase erzeugen
$gmt grdgradient 23_3-1.grd -G23_3-2.grd -A90
# Daten zeichnen
$gmt grdimage 23_3-2.grd -K -P -Jx0.4 -R8/22/0/30 -CGOutPhase.cpt -Bf1a2g4:"x [m]":/f1a2g4:"y [m]":WeSn:."Gradient Out-Phase 23.3 kHz": > vlf-gout-23.eps
$gmt grdcontour 23_3-2.grd -O -K -P -Jx0.4 -R8/22/0/30 -C5 -A5f8 >> vlf-gout-23.eps
# Rand des Erzganges einzeichnen
$gmt psxy links.xy rechts.xy obenrechts.xy -Jx0.4 -R -K -O -W2p/0/200/000 >> vlf-gout-23.eps
# Beschriftung des Randes
echo "12 20 10 0 4 BL - Erzgang "| $gmt pstext -R -Jx0.4 -O -K -G0/200/0 -W255/255/255O -N >> vlf-gout-23.eps
# Skala einbringen
$gmt psscale -O -P -D7/5/6/1 -CGOutPhase.cpt -Bf5a5::/:"H@-z@-/H@-y@- [%]": >> vlf-gout-23.eps

#-----------------------------------------------------
#--------19.6 kHz-------------------------------------
#-----------------------------------------------------

# Farbpalette erzeugen -- In-Phase
$gmt makecpt -Cpolar -T-55/55/10 -Z > InPhase.cpt
# erstes vlf-Bild erzeugen -- In-Phase
$gmt xyz2grd 19_6in.txt -I2/1 -G19_6-1.grd -R8/14/0/30 
# Daten zeichnen
$gmt grdimage 19_6-1.grd -K -P -Jx0.4 -R8/22/0/30 -CInPhase.cpt -Bf1a2g4:"x [m]":/f1a2g4:"y [m]":WeSn:."In-Phase 19.6 kHz": > vlf-in-19.eps
$gmt grdcontour 19_6-1.grd -O -K -P -Jx0.4 -R8/22/0/30 -C20 -A20f8 >> vlf-in-19.eps
$gmt psscale -O -P -D7/5/6/1 -CInPhase.cpt -Bf5a10::/:"H@-z@-/H@-y@- [%]": >> vlf-in-19.eps

# Farbpalette erzeugen
$gmt makecpt -Cpolar -T-30/55/10 -Z > OutPhase.cpt
# zweites vlf-Bild erzeugen -- Out-Phase
$gmt xyz2grd 19_6q.txt -I2/1 -G19_6-1.grd -R8/14/0/30 
# Daten zeichnen
$gmt grdimage 19_6-1.grd -K -P -Jx0.4 -R8/22/0/30 -COutPhase.cpt -Bf1a2g4:"x [m]":/f1a2g4:"y [m]":WeSn:."Out-Phase 19.6 kHz": > vlf-out-19.eps
$gmt grdcontour 19_6-1.grd -O -K -P -Jx0.4 -R8/22/0/30 -C20 -A20f8 >> vlf-out-19.eps
$gmt psscale -O -P -D7/5/6/1 -COutPhase.cpt -Bf5a10::/:"H@-z@-/H@-y@- [%]": >> vlf-out-19.eps

#-----------------------------------------------------
#--------16 kHz-------------------------------------
#-----------------------------------------------------

# Farbpalette erzeugen -- In-Phase
$gmt makecpt -Cpolar -T-100/100/10 -Z > InPhase.cpt
# erstes vlf-Bild erzeugen -- In-Phase
$gmt xyz2grd 16in.txt -I2/1 -G16-1.grd -R16/22/0/30 
# Daten zeichnen
$gmt grdimage 16-1.grd -K -P -Jx0.4 -R8/22/0/30 -CInPhase.cpt -Bf1a2g4:"x [m]":/f1a2g4:"y [m]":WeSn:."In-Phase 16 kHz": > vlf-in-16.eps
$gmt grdcontour 16-1.grd -O -K -P -Jx0.4 -R8/22/0/30 -C20 -A40f8 >> vlf-in-16.eps
$gmt psscale -O -P -D7/5/6/1 -CInPhase.cpt -Bf10a20::/:"H@-z@-/H@-y@- [%]": >> vlf-in-16.eps

# Farbpalette erzeugen
$gmt makecpt -Cpolar -T-100/100/10 -Z > OutPhase.cpt
# zweites vlf-Bild erzeugen -- Out-Phase
$gmt xyz2grd 16q.txt -I2/1 -G16-1.grd -R16/22/0/30 
# Daten zeichnen
$gmt grdimage 16-1.grd -K -P -Jx0.4 -R8/22/0/30 -COutPhase.cpt -Bf1a2g4:"x [m]":/f1a2g4:"y [m]":WeSn:."Out-Phase 16 kHz": > vlf-out-16.eps
$gmt grdcontour 16-1.grd -O -K -P -Jx0.4 -R8/22/0/30 -C20 -A40f8 >> vlf-out-16.eps
$gmt psscale -O -P -D7/5/6/1 -COutPhase.cpt -Bf10a20::/:"H@-z@-/H@-y@- [%]": >> vlf-out-16.eps

rm *.grd *.cpt

