#!/bin/bash

# GMT wrapper script?
gmt=$(which GMT)
 
$gmt gmtset PAPER_MEDIA a4+
$gmt gmtset LABEL_FONT_SIZE 10

# Ternary diagrams
t_title="X"
l_title="Z"
r_title="Y"
outfile="Ternary-GMT.eps"

side="15"
$gmt psxy -R0/1/0/1 -JX${side} -P -K /dev/null > ${outfile}

# Bottom axis:
$gmt psbasemap -R -JX -O -K -Bf0.1S >> ${outfile}

$gmt pstext -JX -R -O -K -N << EOD >> ${outfile}
-0.05  -0.05  24  0  0	1  ${l_title}
0.48   0.88   24  0  0	1  ${t_title}
1      -0.05  24  0  0	1  ${r_title}
EOD

# Left tilted axis
echo "gsave -30 rotate" >> ${outfile}
$gmt psbasemap -R -JX -O -K -Bf0.1W >> ${outfile}
echo "grestore" >> ${outfile}
x=`$gmt gmtmath -Q ${side} ${side} 30 COSD MUL SUB =`
y=`$gmt gmtmath -Q ${side} 30 SIND MUL NEG =`
$gmt psxy -R -JX -O -K -X$x -Y$y /dev/null >> ${outfile}

# Right tilted axis
echo "gsave 30 rotate" >> ${outfile}
$gmt psbasemap -R -JX -O -K -Bf0.1E >> ${outfile}
echo "grestore" >> ${outfile}
x=`$gmt gmtmath -Q $x NEG =`
y=`$gmt gmtmath -Q $y NEG =`
$gmt psxy -R -JX -O -K -X$x -Y$y /dev/null >> ${outfile}

awk '{print ($1+2*$3)/(2*($1+$2+$3))+0.005, sqrt(3)*$1/(2*($1+$2+$3))+0.005, 12, 0, 0, 1, $4}' data.dat | \
    $gmt pstext -JX -R -O -K -N >> ${outfile}

awk '{print ($1+2*$3)/(2*($1+$2+$3)), sqrt(3)*$1/(2*($1+$2+$3))}' data.dat | \
    $gmt psxy -JX -R -O -Sc0.18 -G0 -N >> ${outfile}

