#!/bin/bash

# GMT wrapper script?
gmt=$(which GMT)
 
$gmt gmtset PAPER_MEDIA a4+
$gmt gmtset LABEL_FONT_SIZE 10

# Ternary basemap
side="8"
outfile="Ternary-GMT-Full.eps"

#######################################################
## FIRST TRIANGLE
######################################################
$gmt psxy -R0/100/0/100 -JX-${side} -P -K /dev/null > ${outfile}

# Bottom axis:
$gmt psbasemap -R -JX -U -O -K -B50f5:"<- Ca2+"::,%:S >> ${outfile}

# Left tilted axis
$gmt psxy -R -JX${side} -P -O -K /dev/null >> ${outfile}
echo "gsave -30 rotate" >> ${outfile}
$gmt psbasemap -R -JX -O -K -B50f5:"Feldspat"::,%:W >> ${outfile}
echo "grestore" >> ${outfile}

# Right tilted axis
$gmt psxy -R -JX-${side} -P -O -K /dev/null >> ${outfile}
x=`$gmt gmtmath -Q ${side} ${side} 30 COSD MUL SUB =`
y=`$gmt gmtmath -Q ${side} 30 SIND MUL NEG =`
$gmt psxy -R -JX -O -K /dev/null -X$x -Y$y >> ${outfile}
echo "gsave 30 rotate" >> ${outfile}
$gmt psbasemap -R -JX -O -K -B50f5:"Biotite"::,%:e >> ${outfile}
echo "grestore" >> ${outfile}
x=`$gmt gmtmath -Q $x NEG =`
y=`$gmt gmtmath -Q $y NEG =`
$gmt psxy -R -JX -O -K -X$x -Y$y /dev/null >> ${outfile}
awk '{if (NR > 2) print 4*($1+2*$3)/($1+$2+$3),6.92820323*$1/($1+$2+$3) }' \
< data | $gmt psxy -JX${side} -R0/${side}/0/${side} -Si0.3c -O -K -W1 >> ${outfile}


##################################################################
## SECOND TRIANGLE
##################################################################

Ox_side=`$gmt gmtmath -Q ${side} 1 ADD =`
$gmt psxy -R -JX -O -K /dev/null -Xa$Ox_side >> ${outfile}
$gmt psxy -R0/100/0/100 -JX${side} -P -O -K /dev/null >> ${outfile}

# Bottom axis:
$gmt psbasemap -R -JX -O -K -B50f5:"Quartz"::,%:S >> ${outfile}

# Left tilted axis
$gmt psxy -R -JX-${side} -P -O -K /dev/null >> ${outfile}
echo "gsave -30 rotate" >> ${outfile}
$gmt psbasemap -R -JX -O -K -B50f5:"Feldspat"::,%:W >> ${outfile}
echo "grestore" >> ${outfile}

# Right tilted axis. We have to move origin.
$gmt psxy -R -JX${side} -P -O -K /dev/null >> ${outfile}
x=`$gmt gmtmath -Q ${side} ${side} 30 COSD MUL SUB =`
y=`$gmt gmtmath -Q ${side} 30 SIND MUL NEG =`
$gmt psxy -R -JX -O -K /dev/null -X$x -Y$y >> ${outfile}
echo "gsave 30 rotate" >> ${outfile}
$gmt psbasemap -R -JX -O -K -B50f5:"Biotite"::,%:E >> ${outfile}
echo "grestore" >> ${outfile}
## We reset the origine!
x=`$gmt gmtmath -Q $x NEG =`
y=`$gmt gmtmath -Q $y NEG =`
$gmt psxy -R -JX -O -K -X$x -Y$y /dev/null >> ${outfile}
## We plot the data!
awk '{if (NR > 2) print 4*($4+2*$6)/($4+$5+$6),6.9280323*$4/($4+$5+$6) }' \
< data | $gmt psxy -JX${side} -R0/${side}/0/${side} -Si0.3c -O -K -W1 >> ${outfile}

Ox_side=`$gmt gmtmath -Q $Ox_side NEG =`
$gmt psxy -R -JX -O -K -X$Ox_side /dev/null >> ${outfile}


####################################################################
## Diamond part of diagram
####################################################################

Ox_side=`$gmt gmtmath -Q ${side} 2 DIV 0.5 ADD =`
Oy_side=`$gmt gmtmath -Q $Ox_side 30 SIND DIV 60 SIND MUL =`
$gmt psxy -R -JX -O -K /dev/null -X$Ox_side -Y$Oy_side >> ${outfile}
$gmt psxy -R0/100/0/100 -JX${side} -P -O -K /dev/null >> ${outfile}

##########################TOP TRIANGLE##############################
##
# Left top tilted axis
echo "gsave -30 rotate" >> ${outfile}
$gmt psbasemap -R -JX -O -K -B50f5:"Feldspat"::,%:W >> ${outfile}
echo "grestore" >> ${outfile}


# Right top tilted axis. We have to move origin.
x=`$gmt gmtmath -Q ${side} ${side} 30 COSD MUL SUB =`
y=`$gmt gmtmath -Q ${side} 30 SIND MUL NEG =`
$gmt psxy -R -JX -O -K /dev/null -X$x -Y$y >> ${outfile}
echo "gsave 30 rotate" >> ${outfile}
$gmt psbasemap -R -JX -O -K -B50f5:"Biotite"::,%:E >> ${outfile}
echo "grestore" >> ${outfile}
## We reset the origine!
x=`$gmt gmtmath -Q $x NEG =`
y=`$gmt gmtmath -Q $y NEG =`
$gmt psxy -R -JX -O -K -X$x -Y$y /dev/null >> ${outfile}

awk '{if (NR > 2) print 4*($1+2*$3)/($1+$2+$3),6.9280323*$1/($1+$2+$3) }' \
< data | $gmt psxy -JX${side} -R0/${side}/0/${side} -Sc0.2i -O -K -W1 >> ${outfile}


Ox_side=`$gmt gmtmath -Q $Ox_side NEG =`
Oy_side=`$gmt gmtmath -Q $Oy_side NEG =`
$gmt psxy -R -JX -O -K -X$Ox_side -Y$Oy_side /dev/null >> ${outfile}

#############################Bottom Triangle##################
##
Ox_side=`$gmt gmtmath -Q ${side} 2 DIV 0.5 ADD =`
Oy_side=`$gmt gmtmath -Q $Ox_side 30 SIND DIV 60 SIND MUL =`
$gmt psxy -R -JX -O -K /dev/null -X$Ox_side -Y$Oy_side >> ${outfile}
$gmt psxy -R0/100/0/100 -JX${side} -P -O -K /dev/null >> ${outfile}

## Left bottom tilted axis
x=`$gmt gmtmath -Q ${side} 30 COSD MUL =`
y=`$gmt gmtmath -Q ${side} 30 SIND MUL =`
$gmt psxy -R -JX -O -K /dev/null -X$x -Y$y >> ${outfile}
echo "gsave -150 rotate" >> ${outfile}
$gmt psbasemap -R -JX -O -K -B100f5:"Try"::,%:E >> ${outfile}
echo "grestore" >> ${outfile}
## We reset the origine!
x=`$gmt gmtmath -Q $x NEG =`
y=`$gmt gmtmath -Q $y NEG =`
$gmt psxy -R -JX -O -K -X$x -Y$y /dev/null >> ${outfile}


# Right bottom tilted axis. We have to move origin.  
x=${side}
y=0
#x=`$gmt gmtmath -Q ${side} ${side} 30 COSD MUL SUB =`
#y=`$gmt gmtmath -Q ${side} 30 SIND MUL SUB NEG =`
$gmt psxy -R -JX -O -K /dev/null -X$x -Y$y >> ${outfile}
echo "gsave 150 rotate" >> ${outfile}
$gmt psbasemap -R -JX -O -K -B100f5:"Biotite"::,%:W >> ${outfile}
echo "grestore" >> ${outfile}
## We reset the origine!
x=`$gmt gmtmath -Q $x NEG =`
y=`$gmt gmtmath -Q $y NEG =`
$gmt psxy -R -JX -O -K -X$x -Y$y /dev/null >> ${outfile}


## We plot the data!
x=${side}
y=0
$gmt psxy -R -JX -O -K /dev/null -X$x -Y$y >> ${outfile}
echo "gsave 180 rotate" >> ${outfile}
awk '{if (NR > 2) print 4*($1+2*$3)/($1+$2+$3),6.9280323*$1/($1+$2+$3) }' \
< data | $gmt psxy -JX${side} -R0/${side}/0/${side} -Sc0.2i -O -K -W1 >> ${outfile}
echo "grestore" >> ${outfile}
## We reset the origine!
x=`$gmt gmtmath -Q $x NEG =`
y=`$gmt gmtmath -Q $y NEG =`
$gmt psxy -R -JX -O -X$x -Y$y /dev/null >> ${outfile}


gv ${outfile} &


