#!/bin/bash
# (c) 2006, Assela Pathirana under GNU GPL 2.0 (http://www.gnu.org/copyleft/gpl.html)
#############

# GMT wrapper script?
gmt=$(which GMT)

#Do some input checking and help out the first time users
sourcef="$1.txt"
if [[ $# -lt 1 ]] 
then
  echo 'to create a scattergram from the datafile named <arg1>''.txt'' and to save it in <arg1>.eps'
  echo "The data file <arg1>.txt should  have the data in two columns, seperated by commas. The first line of input should be the axes titles, not data. "
  echo 'first run with only \<arg1> as file name. '
  echo "Then after seeing the range of data to plot - run with all five arguments <arg1> <dx> <dy>"
  exit 1
else
  if [[ ! -f "$sourcef" ]]; then
    echo "There is no file named $sourcef (did you forget to give filename witout .txt part?) " 
    exit 1
  fi
fi
if [ $# -ge 3 ]
then
  ytitle=`head -n1 $sourcef |awk 'BEGIN{FS=","}{print $2}'`
  xtitle=`head -n1 $sourcef |awk 'BEGIN{FS=","}{print $1}'`
  inilt=-I$2/$3
  b="a$2f$2g$2:$xtitle:/a$3f$3g$3:$ytitle:WSne"
  echo "using -B option: "$b
else
  if [ $# -eq 1 ] 
  then
    inilt=-I1E-15/1E-15
    b="a1f1g1WSne"
  else
  #now we are in a strange position. 
    echo "Either give one argument or all five! I quit. "
    exit 1
  fi
fi

#clear any garbage from prvious gmt runs/attempts
rm -f .gmtcommands* .gmtdefaults*

#set some constants
$gmt gmtset LABEL_FONT_SIZE 18
$gmt gmtset PAPER_MEDIA A4+
outf="$1.eps"
trcol="1pt/255/0/0"
bicol="1pt3_3:0/0/0/255"
symcol="255/0/0"
symsym="C.4c"
trendfile="$1.tr.txt"

# calculate a linear(N2) fit for the datafile who has one header rows. Write only 
$gmt trend1d $sourcef   -N2 -Fxmy -H1 | sort -bg > $trendfile

# calculate the coefficient of determination
ybar=`cat $trendfile |awk '{ya=ya+$3;ct++}END{print ya/ct}'`
CD=`cat $trendfile |awk -v ybar=$ybar '{ymb=ymb+($3-ybar)^2;ymh=ymh+($3-$2)^2;ct++}END{printf "%4.2f", (ymb-ymh)/ymb}'`

#find a plotting range
$gmt minmax $sourcef -H1 $inilt -C > $$
xmin=`awk  -v dd=$2 '{print $1-dd}' $$`
ymin=`awk  -v dd=$3 '{print $3-dd}' $$`
xmax=`awk  -v dd=$2 '{print $2+dd}' $$`
ymax=`awk  -v dd=$3 '{print $4+dd}' $$`
\rm -f $$
range='-R'$xmin'/'$xmax'/'$ymin'/'$ymax'/'

echo "Using the range : $range"
echo "now plotting ..."

$gmt psxy -H1 $sourcef $range -W.5p/0/0/0 -G$symcol -S$symsym  -JX10c -B"$b" -P  -K > $outf
$gmt psxy -H1 $trendfile $range -W1.5p/$trcol   -JX10c -B"$b" -P -O -K >> $outf

#legend
$gmt psxy -R0/1/0/1 -JX -O -K -G240 -L -W.75p << END >> $outf 
.055 .955
.405 .955 
.405 .705 
.055 .705 
END

echo "0.09 0.90" | $gmt psxy -R -JX -O -K -S$symsym -G$symcol -W.5p/0/0/0  >> $outf 
echo "0.16 0.90 14 0.0 1 5 Values" | $gmt pstext -R -JX -O -K >> $outf 

$gmt psxy -R -JX -O -K -W$trcol -G0 <<END >>$outf
0.07 0.84
0.14 0.84
END

echo "0.16 0.84 14 0.0 1 5 Trend" | $gmt pstext -R -JX -O -K >> $outf 

$gmt psxy -R0/1/0/1 -JX -O -K -G240 -L -W.75p << END >> $outf 
.96 .06
.96 .21 
.61 .21
.61 .06
END

echo "0.65 0.135 14 0.0 1 5 C.D.= $CD" | $gmt pstext -R -JX -O   >> $outf

#clean up
\rm -f .gmt* $$ $$.* 
