#!/bin/bash

# GMT wrapper script?
gmt=$(which GMT)
 
# allgemeine Angaben fuer GMT
$gmt gmtset PAPER_MEDIA A4+

# nehme Spalten 1, 2 und 7 aus Datei, falls aktuelle Zeile groesser als 2 und Wert Spalte 9 groesser 98
awk ' { if ( NR > 2 && $9 > 98 ) print $1, $2, $7 } ' FUR_2006-12-01.csv > FUR_2006-12-01.xyz
# nutze surface "splines in tension" von GMT um die Daten fuer Darstellung vorzubereiten
$gmt surface -R11.273/11.276/48.162/48.165 -I0.5c -GFUR_2006-12-01.nc FUR_2006-12-01.xyz 
# erzeuge die Abbildung mit dem GMT-Befehl grdimage und leite die PS-Ausgabe weiter an gv
$gmt grdimage FUR_2006-12-01.nc -R -JM6i -P -B0.001 -CFUR.cpt > FUR_2006-12-01.eps
