#!/bin/bash

# GMT wrapper script?
gmt=$(which GMT)
 
# allgemeine Angaben fuer GMT
$gmt gmtset HEADER_FONT_SIZE 12p
$gmt gmtset ANOT_FONT_SIZE 8p
$gmt gmtset LABEL_FONT_SIZE 10p
$gmt gmtset GRID_PEN 0.25pta
$gmt gmtset PAPER_MEDIA A4+

#-----------------------------------------------------
# Farbpalette erzeugen
$gmt makecpt -Cpolar -T0/70/5 -Z > em2001.cpt

# erstes em-Bild erzeugen
$gmt xyz2grd em20010105.xyz -I25/5 -Gem20010105-1.grd -R0/50/0/100 
$gmt grdimage em20010105-1.grd -Cem2001.cpt -Jx0.08 -Bf5a25g25:"x [m]":/f5a25g25:"y [m]":WeSn:."Broadside": -K -P -R-25/50/0/100 -Y15 -X11 > em2001.eps
$gmt grdcontour em20010105-1.grd -C5 -A10f8 -G2 -Jx0.08 -P -R-25/50/0/100 -O -K >> em2001.eps

# Rand der Deponie einzeichnen
$gmt psxy rechtsunten.xy linksoben.xy -Jx -R -K -O -W2p/0/200/000 >> em2001.eps
# Beschriftung des Randes der Deponie
$gmt pstext title.xy -R -Jx -O -K -G0/200/0 -W255/255/255O -N >> em2001.eps

# Skala erzeugen
$gmt psscale -D1/1/4/0.5h  -P -Cem2001.cpt -Bf5a10::/:"mS/m": -Y-2 -X-3 -O -K >> em2001.eps

# zweites em-Bild erzeugen
$gmt xyz2grd em20010123.xyz -I25/5 -Gem20010123-1.grd -R-25/50/0/100   
$gmt grdimage em20010123-1.grd -Cem2001.cpt -Jx0.08 -Bf5a25g25:"x [m]":/f5a25g25:"y [m]":WeSn:."Inline": -O -K -P -R-25/50/0/100  -Y2 -X-6 >> em2001.eps
$gmt grdcontour em20010123-1.grd -C5 -A10f8 -G2 -Jx0.08 -P -R-25/50/0/100 -O -K >> em2001.eps

# Rand der Deponie einzeichnen
$gmt psxy rechtsunten.xy linksoben.xy -Jx -R -K -O -W2p/0/200/000 >> em2001.eps
# Beschriftung des Randes der Deponie
$gmt pstext title.xy -R -Jx -O -K -G0/200/0 -W255/255/255O -N >> em2001.eps

#-----------------------------------------------------
# Mittelwert der Gradienten --> beide nochmal neu auf gleiche Groesse
$gmt xyz2grd em20010105.xyz -Gmittelwert1-1.grd -I25/5 -R0/50/0/100
$gmt xyz2grd em20010123.xyz -Gmittelwert2-1.grd -I25/5 -R0/50/0/100

# Mittelwert der normal gegriddeten
$gmt grdmath mittelwert1-1.grd mittelwert2-1.grd ADD = sum.grd
$gmt grdmath sum.grd 0.5 MUL = mittelwert.grd

# Mittelwert der Messung darstellen
$gmt grdimage mittelwert.grd -Cem2001.cpt -Jx0.08 -Bf5a25g25:"x [m]":/f5a25g25:"y [m]":WeSn:."Mittelwert": -O -K -P -R-25/50/0/100  -Y-13 -X4.5 >> em2001.eps
$gmt grdcontour mittelwert.grd -C5 -A10f8 -G2 -Jx0.08 -P -R-25/50/0/100 -O -K >> em2001.eps

# Rand der Deponie einzeichnen
$gmt psxy rechtsunten.xy linksoben.xy -Jx -R -K -O -W2p/0/200/000 >> em2001.eps
# Beschriftung des Randes der Deponie
$gmt pstext title.xy -R -Jx -O -G0/200/0 -W255/255/255O -N >> em2001.eps


#-----------------------------------------------------
# Gradienten

# Farbpalette erzeugen
$gmt makecpt -Cpolar -T0/3/0.2 -Z > gem2001.cpt

# Gradient vom ersten em-Bild erzeugen
$gmt xyz2grd em20010105.xyz -Ggem20010105-1.grd -I25/5 -R-0/50/0/100
$gmt grdmath gem20010105-1.grd DDX  = ddx.grd
$gmt grdmath gem20010105-1.grd DDY  = ddy.grd
$gmt grdmath ddx.grd ddx.grd MUL  = ddx2.grd
$gmt grdmath ddy.grd ddy.grd MUL  = ddy2.grd
$gmt grdmath ddx2.grd ddy2.grd ADD  = sum.grd
$gmt grdmath sum.grd SQRT  = gem20010105-2.grd
$gmt grdimage gem20010105-2.grd -Cgem2001.cpt -Jx0.08 -Bf5a25g25:"x [m]":/f5a25g25:"y [m]":WeSn:."Gradient-Broadside": -K -P -R-25/50/0/100 -Y15 -X11 > gem2001.eps
$gmt grdcontour gem20010105-2.grd -C0.5 -A1f8 -G2 -Jx0.08 -P -R-25/50/0/100 -O -K >> gem2001.eps

# Rand der Deponie einzeichnen
$gmt psxy rechtsunten.xy linksoben.xy -Jx -R  -O -K -W2p/0/200/000 >> gem2001.eps
# Beschriftung des Randes der Deponie
$gmt pstext title.xy -R -Jx -O -K -G0/200/0 -W255/255/255O -N >> gem2001.eps

# Skala erzeugen
$gmt psscale -D1/1/4/0.5h -P -Cgem2001.cpt -Bf0.4a1::/:mS/m@+2: -Y-2 -X-3 -O -K >> gem2001.eps

# Gradient vom zweiten em-Bild erzeugen
$gmt xyz2grd em20010123.xyz -Ggem20010123-1.grd -I25/5 -R-25/50/0/100
$gmt grdmath gem20010123-1.grd DDX  = ddx.grd
$gmt grdmath gem20010123-1.grd DDY  = ddy.grd
$gmt grdmath ddx.grd ddx.grd MUL  = ddx2.grd
$gmt grdmath ddy.grd ddy.grd MUL  = ddy2.grd
$gmt grdmath ddx2.grd ddy2.grd ADD  = sum.grd
$gmt grdmath sum.grd SQRT  = gem20010123-2.grd
$gmt grdimage gem20010123-2.grd -Cgem2001.cpt -Jx0.08 -Bf5a25g25:"x [m]":/f5a25g25:"y [m]":WeSn:."Gradient-Inline": -O -K -P -R-25/50/0/100 -Y2 -X-6 >> gem2001.eps
$gmt grdcontour gem20010123-2.grd -C0.5 -A1f8 -G2 -Jx0.08 -P -R-25/50/0/100 -O -K >> gem2001.eps

# Rand der Deponie einzeichnen
$gmt psxy rechtsunten.xy linksoben.xy -Jx -R  -O -K -W2p/0/200/000 >> gem2001.eps
# Beschriftung des Randes der Deponie
$gmt pstext title.xy -R -Jx -O -K -G0/200/0 -W255/255/255O -N >> gem2001.eps

#-----------------------------------------------------
# Gradient aus dem Mittelwert bilden
$gmt grdmath mittelwert.grd DDX  = ddx.grd
$gmt grdmath mittelwert.grd DDY  = ddy.grd
$gmt grdmath ddx.grd ddx.grd MUL  = ddx2.grd
$gmt grdmath ddy.grd ddy.grd MUL  = ddy2.grd
$gmt grdmath ddx2.grd ddy2.grd ADD  = sum.grd
$gmt grdmath sum.grd SQRT  = gmittelwert.grd

$gmt grdimage gmittelwert.grd -Cgem2001.cpt -Jx0.08 -Bf5a25g25:"x [m]":/f5a25g25:"y [m]":WeSn:."Gradient vom Mittelwert": -O -K -P -R-25/50/0/100  -Y-13 -X4.5 >> gem2001.eps
$gmt grdcontour gmittelwert.grd -C0.5 -A1f8 -G2 -Jx0.08 -P -R-25/50/0/100 -O -K >> gem2001.eps

# Rand der Deponie einzeichnen
$gmt psxy rechtsunten.xy linksoben.xy -Jx -R  -O -K -W2p/0/200/000 >> gem2001.eps
# Beschriftung des Randes der Deponie
$gmt pstext title.xy -R -Jx -O -G0/200/0 -W255/255/255O -N >> gem2001.eps

rm *.grd *.cpt
