clear all
close all
clc

[pays,a1,a2,cont]=textread('donnees_esperance_vie.txt','%s%f%f%d');

% cont==1 : Asie
% cont==2 : Europe
% cont==3 : Afrique
% cont==4 : Amrique du Nord
% cont==5 : Amrique du Sud
% cont==6 : Ocanie

x1=a2(cont==2);
x2=a2(cont==4);

xb1=mean(x1);
xb2=mean(x2);

n1=length(x1);
n2=length(x2);

s=sqrt((sum((x1-xb1).^2)+sum((x2-xb2).^2))/(n1+n2-2));

disp('H0 : xb1==xb2')

T=abs(xb1-xb2)/s/sqrt(1/n1+1/n2);
disp(['valeur de la statistique : T = ',num2str(T)])

Ts=tq(1-0.05,n1+n2-2);
disp(['seuil de rejet (alpha=5%) : Ts =',num2str(Ts)])

Ts=tq(1-0.10,n1+n2-2);
disp(['seuil de rejet (alpha=10%) : Ts =',num2str(Ts)])

Ts=tq(1-0.20,n1+n2-2);
disp(['seuil de rejet (alpha=20%) : Ts =',num2str(Ts)])

P=1-tp(T,n1+n2-2);
disp(['proba de rejet  tort H0 : P = ',num2str(P)])

% comparaison Europe-Afrique : on peut rejeter l'hypothse nulle avec moins
% de 6 chances sur 100 de se tromper ==> esprance de vie significativement
% diffrente entre l'Europe et l'Afrique