% Statbox 4.2 library of statistical routines
%
% Regression
%   regr       - least squares regression
%   logist     - logistic regression
%	ordinal    - ordinal logistic regression
%   poisson    - poisson regression
%   mprony     - fit sum of exponential functions by nonlinear l.s.
%   frequenc   - frequency estimation by nonlinear l.s.
%   rb_ml      - fit randomized block model by maximum likelihood
%   rb_reml    - fit randomized block model by residual max likelihood
%
% Other functions associated with regression and designed experiments
%   excise     - remove missing values
%   levels     - generate factor levels
%   indicato   - generate indicator variables for factor
%   tally      - univariate frequency table
%   orthpoly   - generate orthogonal polynomials
%   levenb     - Levenberg modified Newton-Raphson
%   logit      - logit function
%
% Probability distributions
%   betap      - Beta distribution function
%   betaq      - Beta distribution quantiles
%   betar      - Beta distribution random deviates
%   binomp     - binomial distribution function
%   binomr     - binomial distribution random deviate
%   chisqp     - chi-squared distribution function
%   chisqq     - chi-squared inverse distribution function
%   chisqr     - chi-squared distribution random deviates
%   fp         - Fisher's F distribution function
%   fq         - Fisher's F distribution quantiles
%   fr         - Fisher's F distribution random deviates
%   gammad     - gamma distribution density function
%   gammap     - gamma distribution function
%   gammaq     - gamma distribution quantiles
%   gammar     - gamma distribution random deviates
%   normp      - normal distribution function
%   normq      - normal inverse distribution function
%   normr      - normal random deviates
%   normqq     - normal probability plot
%   poisp      - Poisson distribution function
%   poisr      - Poisson distribution random deviates
%   tp         - Student's t distribution function
%   tq         - Student's t distribution quantiles
%
% Times series
%   ma         - moving average smoother
%   runmed     - running median of three
%
% Special functions
%   digamma    - digamma function
%   trigamma   - trigamma function
%
% Quadrature
%   gquad      - Legendre quadrature
%   gquad6     - six point Legendre quadrature
%   grule      - compute Legendre nodes and weights
%   int0infy   - Laguerre quadrature
%   laguerre   - compute Laguerre nodes and weights
%   laguerr2   - Laguerre nodes and weights for gamma expectation
%   gausscos   - 16 point Gauss-cos nodes and weights
%   clencurt   - Clenshaw-Curtis integration
%
% Other matrix functions
%   diagsum    - sums of diagonals of matrix
%   expv       - matrix exponential by Krylov subspace projection
%   mexpv      - expv specialized for Markov chains
%   invits     - eigenvalue nearest zero by inverse iteration

% GKS 18 May 2002
