
	module derivative

	contains



c --------------------------------------------------------

	subroutine pder(h,f,dx,nx,nz,dir,dim,nop)

	real h(nx,nz)
	real f(nx,nz)
!hpf$	distribute *(*,block), shadow(0,4) :: f
!hpf$   align h with f


	parameter(maxnop=8)
        real g(maxnop)
	integer dir,dim
	real dx

c derivative operators

	if(nop==4)then
	g(1)=.0416666666
	g(2)=-1.125
	endif

	if(nop==6)then
	g(1)=-0.00468750000000
     	g(2)= 0.06510416666667
        g(3)=-1.17187500000000
	endif

        if(nop==8)then
        g(1)=0.1344048E-02
        g(2)=-0.1324718E-01
        g(3)=0.8948020E-01
        g(4)=-0.1211563E+01
        endif

c the symmetry

         do i=nop/2+1,nop
          g(i) = -g(nop-i+1)
         enddo

	if (dim == 1) then
	if ( dir == -1 )then

		if(nop==2)then
		forall (i=2:nx-1,j=2:nz-1)
		h(i,j)=(f(i,j)-f(i-1,j))/dx	
		end forall
		endif		

		if(nop==4)then
		forall (i=3:nx-3,j=3:nz-3)
		h(i,j)=(g(1)*f(i-2,j)+ 
     &		        g(2)*f(i-1,j)+ 
     &		        g(3)*f(i  ,j)+ 
     &		        g(4)*f(i+1,j))/dx 
		end forall
		endif		

		if(nop==8)then
		forall (i=5:nx-5,j=5:nz-5)
		h(i,j)=(g(1)*f(i-4,j)+ 
     &		        g(2)*f(i-3,j)+ 
     &		        g(3)*f(i-2,j)+ 
     &		        g(4)*f(i-1,j)+ 
     &		        g(5)*f(i  ,j)+ 
     &		        g(6)*f(i+1,j)+ 
     &		        g(7)*f(i+2,j)+ 
     &		        g(8)*f(i+3,j))/dx 
		end forall
		endif		

	else

		if(nop==2)then
		forall (i=2:nx-1,j=2:nz-1)
		h(i,j)=(f(i+1,j)-f(i,j))/dx	
		end forall
		endif


		if(nop==4)then
		forall (i=3:nx-3,j=3:nz-3)
		h(i,j)=(g(1)*f(i-1,j)+ 
     &		        g(2)*f(i,j)+ 
     &		        g(3)*f(i+1,j)+ 
     &		        g(4)*f(i+2,j))/dx 
		end forall
		endif		

		if(nop==8)then
		forall (i=5:nx-5,j=5:nz-5)
		h(i,j)=(g(1)*f(i-3,j)+ 
     &		        g(2)*f(i-2,j)+ 
     &		        g(3)*f(i-1,j)+ 
     &		        g(4)*f(i  ,j)+ 
     &		        g(5)*f(i+1,j)+ 
     &		        g(6)*f(i+2,j)+ 
     &		        g(7)*f(i+3,j)+ 
     &		        g(8)*f(i+4,j))/dx 
		end forall
		endif		

	endif

	else

	if ( dir == -1 )then

		if(nop==2)then
		forall (i=2:nx-1,j=2:nz-1)
		h(i,j)=(f(i,j)-f(i,j-1))/dx	
		end forall
		endif		

		if(nop==4)then
		forall (i=3:nx-3,j=3:nz-3)
		h(i,j)=(g(1)*f(i,j-2)+ 
     &		        g(2)*f(i,j-1)+ 
     &		        g(3)*f(i,j)+ 
     &		        g(4)*f(i,j+1))/dx 
		end forall
		endif		

		if(nop==8)then
		forall (i=5:nx-5,j=5:nz-5)
		h(i,j)=(g(1)*f(i,j-4)+ 
     &		        g(2)*f(i,j-3)+ 
     &		        g(3)*f(i,j-2)+ 
     &		        g(4)*f(i,j-1)+ 
     &		        g(5)*f(i,j)+ 
     &		        g(6)*f(i,j+1)+ 
     &		        g(7)*f(i,j+2)+ 
     &		        g(8)*f(i,j+3))/dx 
		end forall
		endif		

	else

		if(nop==2)then
		forall (i=2:nx-1,j=2:nz-1)
		h(i,j)=(f(i,j+1)-f(i,j))/dx	
		end forall
		endif


		if(nop==4)then
		forall (i=3:nx-3,j=3:nz-3)
		h(i,j)=(g(1)*f(i,j-1)+ 
     &		        g(2)*f(i,j)+ 
     &		        g(3)*f(i,j+1)+ 
     &		        g(4)*f(i,j+2))/dx 
		end forall
		endif		

		if(nop==8)then
		forall (i=5:nx-5,j=5:nz-5)
		h(i,j)=(g(1)*f(i,j-3)+ 
     &		        g(2)*f(i,j-2)+ 
     &		        g(3)*f(i,j-1)+ 
     &		        g(4)*f(i,j)+ 
     &		        g(5)*f(i,j+1)+ 
     &		        g(6)*f(i,j+2)+ 
     &		        g(7)*f(i,j+3)+ 
     &		        g(8)*f(i,j+4))/dx 
		end forall
		endif		
	endif
	endif
	

        end subroutine pder


c --------------------------------------------------------

	subroutine inter(h,f,nx,nz,dir,dim,nop)

	real h(nx,nz)
	real f(nx,nz)
!hpf$	distribute *(*,block), shadow (0,4) :: f
!hpf$   align h with f

	integer dir,dim
	real dx

	if (dim == 1) then
	   if ( dir == -1 )then

		forall (i=2:nx-1,j=2:nz-1)
		h(i,j)=0.5*(f(i,j)+f(i-1,j))
		end forall

	else

		forall (i=2:nx-1,j=2:nz-1)
		h(i,j)=0.5*(f(i+1,j)+f(i,j))
		end forall

	endif

	else

	if ( dir == -1 )then

		forall (i=2:nx-1,j=2:nz-1)
		h(i,j)=0.5*(f(i,j)+f(i,j-1))
		end forall

	else

		forall (i=2:nx-1,j=2:nz-1)
		h(i,j)=0.5*(f(i,j+1)+f(i,j))
		end forall

	endif

	endif
	

        end subroutine inter

	end module derivative
