
	subroutine psv_check

	include 'common.h'
	character*50 file


	write(*,*)' ----------------------------- '
	write(*,*)'        The set up  '
	write(*,*)' ----------------------------- '
	write(*,*)' '
	write(*,*)' seisfile       :  ',seisfile
	write(*,*)' recfile        :  ',recfile
	write(*,*)' snapfile       :  ',snapfile
	write(*,*)' '
	write(*,*)' nx		:  ',nx
	write(*,*)' nz		:  ',nz
	write(*,*)' nt		:  ',nt
	write(*,*)' '
	write(*,*)' dr		:  ',dr
	write(*,*)' dphi     	:  ',dphi
	write(*,*)' dt		:  ',dt
	write(*,*)' izfree	:  ',izfree
	write(*,*)' iord	:  ',iord
	write(*,*)' nop    	:  ',nop
	write(*,*)' nabsorb	:  ',nabsorb
	write(*,*)' aabsorb	:  ',aabsorb
	write(*,*)' '
	write(*,*)' model_type  :  ',model_type
	write(*,*)' vs0         :  ',vs0
	write(*,*)' vp0         :  ',vp0
	write(*,*)' rho0        :  ',rho0
	write(*,*)' '
	write(*,*)' isx         :  ',isx
	write(*,*)' sdepth      :  ',sdepth


c calculate source depth index

	   do iz=1,nz-1
                depth1=rmax-vr2(iz)
                depth2=rmax-vr2(iz+1)
                if(sdepth.gt.depth1.and.sdepth.lt.depth2)then
                        if(sdepth-depth1.le.depth2-sdepth)then
                        isz=iz
                	else
                        isz=iz+1
                	endif
		endif
           enddo

	write(*,*)' isz         :  ',isz
	write(*,*)' Source depth : ',vr2(izfree)-(vr2(isz)+vr2(isz+1))/2.
	write(*,*)' aa          :  ',aa
	write(*,*)' it0         :  ',it0
	write(*,*)' alpha       :  ',alpha
	write(*,*)' source_type :  ',source_type
	write(*,*)' '
	write(*,*)' Rmax        :  ',Rmax
	write(*,*)' MaxR        :  ',vr1(1)
	write(*,*)' MinR        :  ',vr2(nz)
	write(*,*)' '
	write(*,*)' Rfree (u_theta) : ',vr1(izfree)
	write(*,*)' Rfree (u_rad) : ',vr2(izfree)
	write(*,*)' '
	write(*,*)' icheck : ',icheck
	write(*,*)' icheckpoint : ',icheckpoint
	write(*,*)' '
	write(*,*)' Thetamin	:  ',vtheta1(1)
	write(*,*)' Thetamax    :  ',vtheta2(nx)
	write(*,*)' Max darc    :  ',vr1(1)*dphi	
	write(*,*)' Min darc    :  ',vr2(nz)*dphi	
	write(*,*)' '
	write(*,*)' Max(vp)     :  ',maxval(sqrt((lam+2*mu)/rho))
	write(*,*)' Min(vp)     :  ',minval(sqrt((lam+2*mu)/rho))
	write(*,*)' Max(vs)     :  ',maxval(sqrt(mu/rho))
	write(*,*)' Min(vs)     :  ',minval(sqrt(mu/rho))
	write(*,*)' Max(rho)     :  ',maxval(rho)
	write(*,*)' Min(rho)     :  ',minval(rho)
	write(*,*)' '
	write(*,*)' Stability factor (r)     :  ',maxval(sqrt((lam+2*mu)/rho))*dt/dr
c	write(*,*)' Stability factor (theta) min:  ',maxval(sqrt((lam+2*mu)/rho))*dt/(vr1(1)*dphi)
	write(*,*)' Stability factor (Alter) min:  ',(maxval(sqrt((lam+2*mu)/rho))*dt/dr)**2*
     & 	(1+  (dr/(vr1(1)*dphi))**2 )
c	write(*,*)' Stability factor (theta) max:  ',maxval(sqrt((lam+2*mu)/rho))*dt/(vr1(nz)*dphi)
	write(*,*)' Stability factor (Alter) max:  ',(maxval(sqrt((lam+2*mu)/rho))*dt/dr)**2*
     & 	(1+  (dr/(vr1(nz)*dphi))**2 )
	write(*,*)' '
	write(*,*)' Receivers '
	write(*,*)' ixa           : ',ixa
	write(*,*)' ixe           : ',ixe
	write(*,*)' Receiver depth (r) ',vr1(izfree)-vr1(izrec)
	write(*,*)' '
	do i=1,nr
	write(*,*)' Receiver (u_r) : ',i,' Theta : ',rec_loc(i)
	enddo
	write(*,*)' '
	write(*,*)' izrec           : ',izrec
	write(*,*)' isamp           : ',isamp
	write(*,*)' isnap          :  ',isnap
	write(*,*)' '


c model output

	file=seisfile(1:lnblnk(seisfile))//'_model'
	open(10,file=file,status='unknown')
	write(10,*)'  iz        depth         rho             vs               vp '	
	do iz=1,nz
	write(10,4)iz,(rmax-r1(1,iz))/1000.,rho(1,iz),sqrt(mu(1,iz)/rho(1,iz)),
     &                     sqrt((lam(1,iz)+2*mu(1,iz))/rho(1,iz))
	enddo
	close(10)

 4	format(i4,'  ',f10.4,'   ',f10.4,'   ',f10.4,'   ',f10.4)

	write(*,*)' '
	write(*,*)' '
	write(*,*)' '
	write(*,*)' Starting time evolution for ',nt,' time steps  '
	write(*,*)' on ',number_of_processors(),' processors '
	write(*,*)' '
	write(*,*)' '
	write(*,*)' '
	return
	end
