c -----------------------------------
c
c progam prem to generate radially symmetric earth models
c
c izfree included  4-8-94

	subroutine prem

	include 'common.h'

	ddr=0.001*dmax/(nz-2*izfree)
	re=6371.0

	write(*,*)' Generating Earth model .... '
	write(*,*)' No. of radii  :  ',nz
	write(*,*)' izfree     : ',izfree
	write(*,*)' Max depth :      ',dmax
	write(*,*)' '

	do i=1,nz

	depth=(i-izfree)*ddr
	dist=re-depth
	x=dist/re




c	if(dist.lt.6371.and.dist.ge.6368)then
c	vrho(i)=1.020
c	vlam(i) =1.450
c	vmu(i) =0.
	if(dist.ge.6356)then
	vrho(i)=2.6
	vlam(i)=5.8
	vmu(i)=3.2
	elseif(dist.lt.6356.and.dist.ge.6346.6)then 
	vrho(i)=2.9
	vlam(i)=6.8
	vmu(i)=3.9
	elseif(dist.lt.6346.6.and.dist.ge.6151)then 
	vrho(i)=2.691+.6924*x
	vlam(i)=4.1875+3.9382*x
	vmu(i)=2.1519+2.3481*x
	elseif(dist.lt.6151.and.dist.ge.5971)then 
	vrho(i)=7.1089-3.8045*x
	vlam(i)=20.3926-12.2569*x
	vmu(i)=8.9496-4.4597*x
	elseif(dist.ge.5771)then 
	vrho(i)=11.2494-8.0298*x
	vlam(i)=39.7027-32.6166*x
	vmu(i)=22.3512-18.5856*x
	elseif(dist.lt.5771.and.dist.ge.5701)then 
	vrho(i)=5.3197-1.4836*x
	vlam(i)=19.0957-9.8672*x
	vmu(i)=9.9839-4.9324*x
	elseif(dist.lt.5701.and.dist.ge.5600)then 
	vrho(i)=7.9565-6.4761*x+5.5283*x**2-3.0807*x**3
	vlam(i)=29.2766-23.6027*x+5.5242*x**2-2.5514*x**3
	vmu(i)=22.3459-17.2473*x-2.0834*x**2+0.9783*x**3
	elseif(dist.lt.5600.and.dist.ge.3630)then 
	vrho(i)=7.9565-6.4761*x+5.5283*x**2-3.0807*x**3
	vlam(i)=24.9520-40.4673*x+51.4832*x**2-26.6419*x**3
	vmu(i)=11.1671-13.7818*x+17.4575*x**2-9.2777*x**3
	elseif(dist.lt.3630.and.dist.ge.3480)then 
	vrho(i)=7.9565-6.4761*x+5.5283*x**2-3.0807*x**3 
	vlam(i)=15.3891-5.3181*x+5.5242*x**2-2.5514*x**3
	vmu(i)=6.9254+1.4672*x-2.0834*x**2+.9783*x**3
	elseif(dist.lt.3480.and.dist.ge.1221.5)then 
	vrho(i)=12.5815-1.2638*x-3.6426*x**2-5.5281*x**3
	vlam(i)=11.0487-4.0362*x+4.8023*x**2-13.5732*x**3
	vmu(i)=0.
	elseif(dist.lt.1221.5)then
	vrho(i)=13.0885-8.8381*x**2
	vlam(i)=11.2622-6.3640*x**2
	vmu(i)=3.6678-4.4475*x**2
	endif

	enddo


	do i=nz-izfree,nz
	vmu(i)=vmu(nz-izfree-1)
	vrho(i)=vrho(nz-izfree-1)
	vlam(i)=vlam(nz-izfree-1)
	enddo

	end
