
clear
clf

% Simple finite difference solver
%
% Acoustic wave equation  p_tt   = c^2 p_xx + src
% 1-D regular grid


% Basic parameters

nt=1000;    % number of time steps
c0=1.;       % acoustic velocity
eps=1.;     % stability limit
isnap=2;

mx=80;     % number of grid points in x 
mz=mx;
my=80;
mp=zeros([mx+2 my mz+2]); mpnew=mp; mpold=mp; d2mpx=mp; d2mpy=mp; d2mpz=mp;  
mc=mp; mc=mc+c0;% initialization of pressure fields
dx=1./(mx-1);  % calculate space increment
isx=floor(mx/2);
isz=floor(mz/2);
dt=.5*eps*dx/max(max(max(mc))); % calculate time step from stability criterion

% source time function

f0=1./(10.*dt);     					% dominant frequency
t=(1:nt)*dt; t0=4/f0;				% initialize time axis
src=exp(-f0^2*(t-t0).*(t-t0));	% source time function
src=diff(src);							% time derivative to obtain Gaussian


% Time stepping

for it=1:nt,
      
   % FD
   
   disp(sprintf(' Time step : %i',it));
   
   
      % derivatives and extrapolation in 3D block
   
   for j=2:mx+1,
      for k=2:my-1,
         for l=2:mz+1,
            d2mpx(j,k,l)=(mp(j+1,k,l)-2*mp(j,k,l)+mp(j-1,k,l))/dx^2; 
            d2mpy(j,k,l)=(mp(j,k+1,l)-2*mp(j,k,l)+mp(j,k-1,l))/dx^2;
            d2mpz(j,k,l)=(mp(j,k,l+1)-2*mp(j,k,l)+mp(j,k,l-1))/dx^2;  
         end   
      end
   end
   mpnew=2*mp-mpold+mc.*mc.*(d2mpx+d2mpy+d2mpz)*dt^2;                % time extrapolation
   mpnew(mx/2,my/2,mz/2)=mpnew(mx/2,my/2,mz/2)+src(it)*dt^2;     % add source term
   mpold=mp;											% time levels
   mp=mpnew;
      
   if rem(it,isnap)== 0,
   % Display 
   
   % map center from 3D block
   
   for k=1:mx+2,
      for l=1:mz+2,
         p(k,l)=mp(k,my/2,l); 
      end
   end
   
   
   imagesc(p), axis equal
   
   title(' FD ')
   drawnow
   end
end

   

