function  fx=lowpass(x,dt,fup,n)
% function  fx=lowpass(x,dt,fup,n)
% Simple lowpass filtering 0-phase using butterworth
% x input vector
% dt sampling rate
% fup cutoff frequency
% n order
fN=1/(2*dt);
w=fup/fN;
[B,A] = BUTTER(n,w);
fx = FILTFILT(B, A, x);
% end
