function  fx=bandpass(x,dt,flow,fup,n)
% function  fx=bandpass(x,dt,flow,fup,n)
% Simple bandpass filtering 0-phase using butterworth
% x input vector
% dt sampling rate
% fup cutoff frequency
% n order
fN=1/(2*dt);
w1=flow/fN;
w2=fup/fN;
[B,A] = BUTTER(n,[w1 w2]);
fx = FILTFILT(B, A, x);
% end
