% SLB Project 

% Program to plot 6 component seismograms
% simulated by SeisSol code (ADER-DG method)

% PROFILE

% Pham D. N., H. Igel, and M. Kaeser, 
% Geophysics, LMU Munich.
% Jan. 2009



clear all; close all;

mtype=input('Enter the type of the medium: 1 or 2 (1- Homo, 2 - Layer)):');
        if mtype==1
            f_name1='Homo';
            Res=input('Enter the source index (1 to 5):');
        else
            f_name1='Layer';
            Res=input('Enter the source index (1 or 5):');
        end

        f_name2=[num2str(Res)];

        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % Scale factor for the source so that in all case Mw=0; 
        if (Res==1 & mtype==1)
            Amp_coef=8.4074865549767914e+005; 
        else
            Amp_coef=1;
        end
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%        
       
N_Rec=15; % number of the receiver

cd ..; % Shift to data directory

for aaa=1:round(N_Rec/8)

figure,

    if aaa==round(N_Rec/8)
        ccc=7;
    else
        ccc=8;
    end

    
    for bbb=1:ccc
        
        Result=8*(aaa-1)+bbb;
        
        f_name3=[num2str(Result)];
        
        if Res<10
            filename=[f_name1 '0' f_name2 ' (' f_name3 ').dat'];
        else
            filename=[f_name1 f_name2 ' (' f_name3 ').dat'];
        end


        numvars=6; % Number of variables;

            
        VARS=['V_N';...
        'V_E';...
        'V_Z';...
        'R_N';...
        'R_E';...
        'R_Z'];

    
        fid = fopen(filename,'r');
        tmp=fgets(fid);
        tmp=fgets(fid);
        tmp=fgets(fid);
        tmp=fgets(fid);
        tmp=fgets(fid);
        S=fscanf(fid,'%f');
        fclose('all');


        for j=1:length(S)/(numvars+1)
            for i=1:numvars+1
                SEIS(i,j)=S(i+(j-1)*(numvars+1));
            end
        end


    SEIS(2:i,:)=SEIS(2:i,:)*Amp_coef;

    
   

    for i=1:numvars
        

            if i <=3
                ms='r';
            else
                ms='b';
            end

        kk(bbb,i)=max(abs(SEIS(i+1,:)));
        kkk=kk(1,i);
        
        subplot(2,3,i), 
        plot(SEIS(i+1,:)+(bbb-1)*kkk,SEIS(1,:),ms),
        ht=text((bbb-0.7)*kkk,0.03,sprintf('Rec.%i',8*(aaa-1)+bbb)); 
        set(ht,'Rotation',-90,'FontSize',6)
        xlabel(VARS(i,:)); 
        if (i==1 | i==4)
            ylabel('Time (s)');

        end
        set(gca,'XTick',[],'YDir','reverse');
        
        ylim([SEIS(1,1) SEIS(1,length(SEIS(1,:)))]),
        hold on;
        xlim([-kkk bbb*kkk]);
        
        
    end


    clear SEIS, filename, fid, tmp, S, Result;
    
    
    end

    %%% Plot figure to file
        %pfile=sprintf('./Figs/Fig2_Profile%i_%i.jpg',Res,aaa); eval([' print -djpeg100 ' pfile ]);
        %clear pfile; 

end

cd MatLabCodes; % Back to the program directory