
% Surface wave dispersion (Love waves)

clear 
close all

% Shearer exercise

H = 40000.;
b1 = 3500.; r1 = 2700;
b2= 4500; r2 = 3300;
mu1 = r1*b1^2;
mu2 = r2*b2^2;

ii=1;
for c = 3.8:.1:4.4;
    ii=ii+1;
    w=1./(sqrt(1./b1^2-1./c^2))*1./H*atan( (mu2*sqrt(1/c^2-1/b2^2))/(mu1*(sqrt(1/b1^2-1/c^2))));
    T(ii)=1/w;
    ca(ii)=c;
end

plot(T,ca)
















