
clear

% visualization of Rayleigh wave polarization


beta=4000;
c=.9191*beta;
w=1;f=w/(2*pi);
lam=c/f;
k=2*pi/lam;
dt=.0001;
nt=2*pi*(1/c)/dt;

x3=0;

pause on

for x3=0:1000:10000,

for it=1:nt,
    
    t=it*dt;
    u1=k*(exp(-x3*k*.8475)-.5744*exp(-x3*k*.3933))*sin(-c*t);
    u3=k*(-.8475*exp(-x3*k*.8475)+1.4679*exp(-x3*k*.3933))*cos(-c*t);

    plot(u1,u3,'+'),axis([-k k -k k]), hold on
    xlabel(' x1 ')
    ylabel(' x3 ')
    title(sprintf(' Depth %i m ',x3))
    drawnow,pause(.01)
    
    
end

hold off

end