
% 
% Stress drop and fault size
% 
% Calculate M0 from the moment tensor of the Tohoku-oki earthquake March 11, 2011. 
% Estimate the stress drop in MPa using the relation from Knopoff (eqs. 9.8 and 9.41), w width 150km , L fault length 250km
%  
% 
% The moment tensor (Harvard CMT output)
% 
% Mechanism information 
% Exponent for moment tensor:  29    units: dyne-cm
%          Mrr     Mtt     Mpp     Mrt     Mrp     Mtp
% CMT     1.730  -0.281  -1.450   2.120   4.550  -0.657
% Error   0.006   0.005   0.005   0.068   0.065   0.004
% 
% 
% With these values of M0 and area, estimate the slip assuming vs=4km/s and density ?=2500 kg/m3
% 
% 

clear
close all


M = 1e29 * [1.730  2.120 4.55;
            2.12  -0.281 -.657;
            4.55  -0.657 -1.45];


        M0=0;
        
        for i=1:3,
            for j=1:3,
                M0=M0+M(i,j)^2;
            end
        end
        
M0=sqrt(M0)/sqrt(2);
        
disp(sprintf(' M_0 =  %g dyn-cm ',M0));
M0=M0/1e7;
disp(sprintf(' M_0 =  %g Nm ',M0));

% Stress drop

DS = 2* M0/(pi*150000^2*250000);

disp(sprintf(' Stress drop =  %g MPa ',DS/1e6))

        
        