
% Solution of the reflection coefficient exercise

clear 
close all

ang=1:89;
ang=ang/180*pi;

b=2500.;
a=4000;


% Case 1
da=250;
db=0;
for i=1:length(ang)
    p=sin(ang(i))/a;
    PP(i)=1./(2*cos(ang(i))^2)*da/a - 4*p^2*b^2*db/b;
end

plot((PP),'b-'), axis([0 80 -1 1]) 

hold on


% Case 2
da=250;
db=-400;
for i=1:length(ang)
    p=sin(ang(i))/a;
    PP(i)=1./(2*cos(ang(i))^2)*da/a - 4*p^2*b^2*db/b;
end

plot((PP),'r-'), axis([0 80 -1 1]) 

hold on

% Case 3
da=250;
db=400;
for i=1:length(ang)
    p=sin(ang(i))/a;
    PP(i)=1./(2*cos(ang(i))^2)*da/a - 4*p^2*b^2*db/b;
end

plot((PP),'g-'), axis([0 80 -1 1]) 

hold on


% Case 3
da=-250;
db=-400;
for i=1:length(ang)
    p=sin(ang(i))/a;
    PP(i)=1./(2*cos(ang(i))^2)*da/a - 4*p^2*b^2*db/b;
end

plot((PP),'k-'), axis([0 80 -1 1]) 

hold on

legend(' da+, db0 ',' da+, db- ','da+, db+','da-, db-')

xlabel(' Incidence angle ')
ylabel(' PP ')


