function  G=refl_gradient(m0,xr,v)
% function  reflection_gradient
% Input: - Vector m0 with source doordinates and origin time
%        - Matrix xr with dimensions nr x 3, nr is number of receivers
%          times three space coordinates
%        - v velocity 
% Output: matrix G with partial derivatives w.r.t. model parameters
% 
nr=length(xr(:,1));

for i=1:nr,
    for j=1:4,
        if j<4, 
        G(i,j)= (m0(j)-xr(i,j))/v*( (xr(i,1)-m0(1))^2 + (xr(i,2)-m0(2))^2 + (xr(i,3)-m0(3))^2 )^(-1/2);
        else
        G(i,j)= 1;
        end
    end
end

% end