function  G=refl_gradient(m,xr)
% function  reflection_gradient
% Input: - Vector m0 velocity and depth estimate
%        - Vector xr with coordinates
% Output: matrix G with partial derivatives w.r.t. model parameters
% 
nr=length(xr);

for i=1:nr,
    for j=1:2,
        if j==1,
        G(i,j)= -2./m(1)^2*sqrt( (xr(i)/2)^2 + m(2)^2);
        elseif j==2,
        G(i,j)= 2*m(2)/(m(1)*sqrt( (xr(i)/2)^2 + m(2)^2));
        end
    end
end

% end