	
	subroutine fd_output

	include 'common.h'

	character*50 file

	real vtheta(nx),utmp(nx),u2tmp(nx,nz),ctmp(nx)
 

c gathering seismograms during simulation
	
	vtheta=theta1(:,1)
	utmp=up(:,izrec)
	ctmp=curl(:,izrec)

	do i=1,nr
	iiout=(i-1)*nt+it
	call rec_int(vtheta,nx,rec_loc(i)/180.*pi,
     &		     utmp,seis(iiout))
	call rec_int(vtheta,nx,rec_loc(i)/180.*pi,
     &		     ctmp,cseis(iiout))

	enddo


c output seismograms at the end of simulation

        if(mod(it,iflush)==0 .or.it==nt)then
	write(*,*)' Writing seismograms to file at it =  ',it
      open(unit=20,file=seisfile,status='unknown')
	do i=1,nr*nt
	write(20,*)seis(i)
	enddo
	close(20)
	write(*,*)' Writing rotations to file at it =  ',it
	open(unit=20,file=seisfile(1:lnblnk(seisfile))//'_c',
     &	status='unknown')
	do i=1,nr*nt
	write(20,*)cseis(i)
	enddo
	close(20)

        endif


c snapshot output

	if(it==1.and.isnap>0)then
	file=seisfile(1:lnblnk(seisfile))//'_snp'
	open(unit=99,file=file,status='unknown')
	endif


	if(isnap>0)then
	if(mod(it,isnap)==0)then
	iss=it/isnap
	write(*,*)' Writing snapshot ',iss,' ... '
	u2tmp=up
	do i=1,nx,iout
	do j=1,nz,iout
	write(99,*)u2tmp(i,j)
	enddo
	enddo
	endif
	endif


	return
	end subroutine fd_output
	

c ---------------------------------------------

	subroutine  rec_int(x,nx,xr,f,out)

c this routine interpolates linearly a scalar field known at 
c x(0:nx) and y(0:ny) locations to an arbitrary location
c within xmax and ymax.
c The receiver locations are xr, and yr, the scalar input
c field is plane and the function value at xr and yr is
c out.

	real x(nx)
	real xr,yr,out
	real f(nx)

	do i=1,nx-1
	if(xr .ge. x(i) .and. xr .lt. x(i+1) ) then
	ilow=i
	iup =i+1
	dx=x(i+1)-x(i)
	hx=xr-x(i)
	endif
	enddo

	f1=f(ilow)
	f2=f(iup)

	out = f1 + (f2-f1)/dx*hx

	return
	end


