
	subroutine fd_model 

	include 'common.h'

	real pert(nx,nz)
!hpf$   distribute (*,block), shadow (0,4) :: pert

c initialise cartesian coordinates

	xc=r1*cos(theta1)
	yc=r1*sin(theta1)

c initialize model

	write(*,*)' Begin model '

	if(model_type==1)then

	rho=rho0
	mu1=rho0*vs0**2
	mu2=rho0*vs0**2

	elseif(model_type==2)then

	call sh_prem
	
	rho=rho*1000.
	mu1=mu1*1000.
	mu2=mu2*1000.

	mu1=rho*mu1**2
	mu2=rho*mu2**2

	elseif(model_type==3)then


	call sh_prem
	
	rho=rho*1000.
	mu1=mu1*1000.
	mu2=mu2*1000.

	open(unit=10,file=modelfile,form='unformatted')
	read(10)pert
	close(10)

	write(*,*)minval(pert),'< pert < ',maxval(pert)
	
	rho=rho*(1+0.5*pert/100.)
	mu1=mu1*(1.+pert/100.)
	mu2=mu2*(1.+pert/100.)

	mu1=rho*mu1**2
	mu2=rho*mu2**2

	endif

	write(*,*)' End model '

	return
	end


c -----------------------------------
c
c progam prem to generate radially symmetric earth models
c

	subroutine sh_prem

	include 'common.h'

	real ro,muu

	write(*,*)' Generating Earth model .... '
	write(*,*)' No. of radii  :  ',nz
	write(*,*)' Max depth :      ',dmax
	write(*,*)' '

	re=6371000.

	do k=1,2
	
	do i=1,nz

	if(k==1)then
	depth=(re-r1(1,i))/1000.
	elseif(k==2)then
	depth=(re-r2(1,i))/1000.
	endif

	dist=re/1000.-depth
	x=dist/(re/1000.)


	if(dist.ge.6356)then
	ro=2.6
	muu=3.2
	elseif(dist.lt.6356.and.dist.ge.6346.6)then 
	ro=2.9
	muu=3.9
	elseif(dist.lt.6346.6.and.dist.ge.6151)then 
	ro=2.691+.6924*x
	muu=2.1519+2.3481*x
	elseif(dist.lt.6151.and.dist.ge.5971)then 
	ro=7.1089-3.8045*x
	muu=8.9496-4.4597*x
	elseif(dist.lt.5971.and.dist.ge.5771)then 
	ro=11.2494-8.0298*x
	muu=22.3512-18.5856*x
	elseif(dist.lt.5771.and.dist.ge.5701)then 
	ro=5.3197-1.4836*x
	muu=9.9839-4.9324*x
	elseif(dist.lt.5701.and.dist.ge.5600)then 
	ro=7.9565-6.4761*x+5.5283*x**2-3.0807*x**3
	muu=22.3459-17.2473*x-2.0834*x**2+0.9783*x**3
	elseif(dist.lt.5600.and.dist.ge.3630)then 
	ro=7.9565-6.4761*x+5.5283*x**2-3.0807*x**3
	muu=11.1671-13.7818*x+17.4575*x**2-9.2777*x**3
	elseif(dist.lt.3630.and.dist.ge.3480)then 
	ro=7.9565-6.4761*x+5.5283*x**2-3.0807*x**3 
	muu=6.9254+1.4672*x-2.0834*x**2+.9783*x**3
	elseif(dist.lt.3480.and.dist.ge.1221.5)then 
	ro=12.5815-1.2638*x-3.6426*x**2-5.5281*x**3
	muu=0.
	elseif(dist.lt.1221.5)then
	ro=13.0885-8.8381*x**2
	muu=3.6678-4.4475*x**2
	endif

	if(k==1)then
	rho(:,i)=ro
	mu1(:,i)=muu
	elseif(k==2)then
	mu2(:,i)=muu
	endif

	enddo
	enddo

	return
	end subroutine sh_prem
