function c=taper(a,n)
% TAPER tapers a vector at the beginning (n>0)
%                          or at the end (n<0)

m=abs(n);

% initialize gauss function


if(n>0),
for i=1:m
    taper(m+1-i)=exp(-1/(n/2.5)^2*(i-1)^2);
end
else
for i=1:m
    taper(i)=exp(-1/(n/2.5)^2*(i-1)^2);
end
end

[n1,n2]=size(a);

c=a;

if(n>0),
c(1:m)=c(1:m).*taper';
else
c(n1-m+1:n1)=c(n1-m+1:n1).*taper';
end
