
clear
close all
pause off 

disp(' ')
disp(' ------------------------------------------ ')
disp(' Basic plotting for 2-Component seismograms ')
disp(' ------------------------------------------ ')
disp(' ')

dir

%file1=input(' Give filename for SH component (in single quotes) ');

file1='hokkaido_6_op4';
if ~exist(file1), disp(' File (x) not found '),break, end
disp(' Loading phi-component ')
eval(['load -ascii ' file1]);
%file2=input(' Give filename for rotational component (in single quotes) ');
file2='hokkaido_6_op4_c';
if ~exist(file2), disp(' File (z) not found '),break, end
disp(' Loading curl-component ')
eval(['load -ascii ' file2]);

%nt=input(' Number of time samples (nt) ? ');
nt=17885;
%dt=input(' Time increment (dt) in micros ? ');
dt=0.2012;
%nr=input(' Number of receivers (nr) ? ');
p=input(' Give dominant period  ? ');
src=ricker(dt,p);

s1=eval([file1]);
s2=eval([file2]);


nr=length(s1)/nt;
s1=reshape(s1',nt,nr); 
s2=reshape(s2',nt,nr); 

t=(1:nt)*dt;

for i=1:nr,
s1(:,i)=taper(s1(:,i),1000);
s1(:,i)=taper(s1(:,i),-1000);
s2(:,i)=taper(s2(:,i),1000);
s2(:,i)=taper(s2(:,i),-1000);
end

disp(sprintf(' Number of receivers : %i ',nr))
ir=input(' Give receiver to plot : ')

for i=ir:ir,
s1(:,i)=mconv(s1(:,i),src);
s1(1:nt-1,i)=diff(s1(:,i))/dt;
s2(:,i)=mconv(s2(:,i),src);
end



% find max
rmax1=max(max(abs(s1)));
rmax2=max(max(abs(s2)));
rmax=max([rmax1 rmax2 ]);





plot(t,s1(:,ir)/max(s1(:,ir)),'k-',t,-s2(:,ir)/max(s2(:,ir)),'r-')
title(' Acc - black, Rot - red '),xlabel(' Time (sec) '),


disp(' ... bye ...')
