
	subroutine fd_model 

	include 'common.h'

	real pert(500,500)

c initialise cartesian coordinates

	xc=r1*cos(theta1)
	yc=r1*sin(theta1)

c initialize model

	write(*,*)' Begin model '

	if(model_type==1)then

	rho=rho0
	mu1=rho0*vs0**2
	mu2=rho0*vs0**2

	elseif(model_type==2)then

	call sh_prem
	
	rho=rho*1000.
	mu1=mu1*1000.
	mu2=mu2*1000.

	mu1=rho*mu1**2
	mu2=rho*mu2**2

	elseif(model_type==3)then


	call sh_prem
	
	rho=rho*1000.
	mu1=mu1*1000.
	mu2=mu2*1000.

	open(unit=10,file=modelfile)

	do i=1,500
	do j=1,500
	read(10,*)pert(i,j)
	enddo
	enddo

	gpert(1:500,1:500)=pert
	gpert(1:500,501:nz)=pert
	gpert(501:1000,:)=gpert(1:500,:)
	gpert(1001:1500,:)=gpert(1:500,:)
	gpert(1501:2000,:)=gpert(1:500,:)
	gpert(2001:2500,:)=gpert(1:500,:)
	gpert(2501:3000,:)=gpert(1:500,:)
	gpert(3001:3500,:)=gpert(1:500,:)
	gpert(3501:4000,:)=gpert(1:500,:)
	gpert(4001:4500,:)=gpert(1:500,:)

	gpert=gpert*.02
	write(*,*)minval(gpert),' < gpert < ',maxval(gpert)

	rho=rho*(1.+gpert)
	mu1=mu1*(1.+gpert)
	mu2=mu2*(1.+gpert)

        mu1=rho*mu1**2
        mu2=rho*mu2**2

	elseif(model_type==4)then

        call sh_prem

        rho=rho*1000.
        mu1=mu1*1000.
        mu2=mu2*1000.

c location of the plume

	aaa=5./180.*pi
	bbb=150000.
	x0=60./180.*pi
	y0=rmax-bbb
	ddx=1./180.*pi

	gpert=1.
	
	where( (theta1-x0)**2/aaa**2 + (r1-y0)**2/bbb**2 < 1. )
	gpert=1.-.05*cos((theta1-x0)/(2*aaa)*pi)*cos((r1-y0)/(2*bbb)*pi)
	endwhere

	iii=nint(ddx/dtheta)
	iii0=nint(x0/dtheta)+izfree
	write(*,*)' iii = ',iii  
	

	forall(i=1:nx,j=1:nz,
     &	 r1(i,j).lt.rmax-bbb .and. theta1(i,j).gt.x0-ddx .and.theta1(i,j).lt.x0+ddx)
	gpert(i,j)=.95+abs(.95-gpert(iii0-iii-1,j))*
     &	(1-cos((theta1(i,j)-x0)/(2*ddx)*pi))
	end forall


	open(unit=10,file='PLUME/plume.dat')
	iout=4
	do i=1,nx,iout
	do j=1,nz,iout
	write(10,*)gpert(i,j)
	enddo
	enddo
	close(10)

        rho=rho*gpert
        mu1=mu1*gpert
        mu2=mu2*gpert

        mu1=rho*mu1**2
        mu2=rho*mu2**2

	endif

	write(*,*)' End model '

	return
	end


c -----------------------------------
c
c progam prem to generate radially symmetric earth models
c

	subroutine sh_prem

	include 'common.h'

	real ro,muu

	write(*,*)' Generating Earth model .... '
	write(*,*)' No. of radii  :  ',nz
	write(*,*)' Max depth :      ',dmax
	write(*,*)' '

	re=6371000.

	do k=1,2
	
	do i=1,nz

	if(k==1)then
	depth=(re-r1(1,i))/1000.
	elseif(k==2)then
	depth=(re-r2(1,i))/1000.
	endif

	dist=re/1000.-depth
	x=dist/(re/1000.)


	if(dist.ge.6356)then
	ro=2.6
	muu=3.2
	elseif(dist.lt.6356.and.dist.ge.6346.6)then 
	ro=2.9
	muu=3.9
	elseif(dist.lt.6346.6.and.dist.ge.6151)then 
	ro=2.691+.6924*x
	muu=2.1519+2.3481*x
	elseif(dist.lt.6151.and.dist.ge.5971)then 
	ro=7.1089-3.8045*x
	muu=8.9496-4.4597*x
	elseif(dist.lt.5971.and.dist.ge.5771)then 
	ro=11.2494-8.0298*x
	muu=22.3512-18.5856*x
	elseif(dist.lt.5771.and.dist.ge.5701)then 
	ro=5.3197-1.4836*x
	muu=9.9839-4.9324*x
	elseif(dist.lt.5701.and.dist.ge.5600)then 
	ro=7.9565-6.4761*x+5.5283*x**2-3.0807*x**3
	muu=22.3459-17.2473*x-2.0834*x**2+0.9783*x**3
	elseif(dist.lt.5600.and.dist.ge.3630)then 
	ro=7.9565-6.4761*x+5.5283*x**2-3.0807*x**3
	muu=11.1671-13.7818*x+17.4575*x**2-9.2777*x**3
	elseif(dist.lt.3630.and.dist.ge.3480)then 
	ro=7.9565-6.4761*x+5.5283*x**2-3.0807*x**3 
	muu=6.9254+1.4672*x-2.0834*x**2+.9783*x**3
	elseif(dist.lt.3480.and.dist.ge.1221.5)then 
	ro=12.5815-1.2638*x-3.6426*x**2-5.5281*x**3
	muu=0.
	elseif(dist.lt.1221.5)then
	ro=13.0885-8.8381*x**2
	muu=3.6678-4.4475*x**2
	endif

	if(k==1)then
	rho(:,i)=ro
	mu1(:,i)=muu
	elseif(k==2)then
	mu2(:,i)=muu
	endif

	enddo
	enddo

	return
	end subroutine sh_prem
