
	subroutine fd_init

	include 'common.h'
	character*50 file

	write(*,*)' Begin init '

	if(nt>maxnt)then
	write(*,*)' increase maxnt ... '
	stop
	endif

c source index


	   do iz=izfree,nz-1
		depth1=rmax-r1(1,iz)
		depth2=rmax-r1(1,iz+1)
		if(sdepth.gt.depth1.and.sdepth.le.depth2)then
	   		if(sdepth-depth1.le.depth2-sdepth)then
           		isz=iz
	   		else
	   		isz=iz+1
			endif
		endif
	   enddo

c initialize fields

	up=0.
	srp=0.
	stp=0.


c angular increment
	dxmax=rmax*dtheta
	dxmin=(rmax-dmax)*dtheta

c time increment
c calculate dt from stability

	vmax=maxval( sqrt(mu1/rho) )
	dx=min(dxmin,dxmax,dr)
	dt=stab*dx/(sqrt(2.)*vmax)

	nt=nint(time/dt)

	if(nt>maxnt)then
	write(*,*)nt,' > ',maxnt
	write(*,*)' Increase maxnt and recompile ! '
	stop
	endif


c source

	aaa=1./(2.*aa)

	if(aa==0.)then
	so(it0)=1.
	else

c	do i=1,nt
c	tt=(i-it0)*dt
c	so(i)=-2.*(aaa**2)*tt*exp(-(aaa*tt)**2)
c	enddo

	rn=2.
	call source(so,nt,dt,aa,rn)

c normalize
	
	smax=0.
	do i=1,nt
	if(abs(so(i)).gt.smax)then
	smax=abs(so(i))
	endif
	enddo
	do i=1,nt
	so(i)=so(i)/smax
	enddo

	endif

 
	file=seisfile(1:lnblnk(seisfile))//'_src'
	open(unit=33,file=file,status='unknown')
	do i=1,nt
	write(33,*)so(i)
	enddo
 11	format(e10.5)
	close(33)


	write(*,*)' End init '

	return
	end

c -----------------------------------------------

	subroutine initialise_r_and_theta

	include 'common.h'


c initialise r and theta

	nzr=nz-2*(izfree-1)
	dr=dmax/(nzr-1)

	forall(iz=1:nz)
 	r1(:,iz)=rmax-(iz-izfree)*dr
 	r2(:,iz)=rmax-(iz-izfree+.5)*dr
	end forall

c initialise theta

	nxt=nx-2*(izfree-1)
c	dtheta=pi/(nxt-1)
	dtheta=tmax/180*pi/(nxt-1)

	forall(ix=1:nx)
	theta1(ix,:)=(ix-izfree)*dtheta
	theta2(ix,:)=(ix-izfree+0.5)*dtheta
	end forall

c save coords

	open(unit=10,file=seisfile(1:lnblnk(seisfile))//'_tco')
	open(unit=11,file=seisfile(1:lnblnk(seisfile))//'_rco')
	write(10,*)nx
	do i=1,nx
	write(10,*)theta1(i,1)
	enddo
	close(10)
	write(11,*)nz
	do i=1,nz
	write(11,*)r1(1,i)
	enddo
	close(11)

	where(sin(theta1)==0)theta1=1.

	cot1=cos(theta1)/sin(theta1)
	cot2=cos(theta2)/sin(theta2)



	return
	end


c--------------------------------------------------------------
c
c N           Form of the far field displacement
c
c T           Dominating period ( sec )
c
c

        subroutine source(s,nt,dt,pt,rn)

        real s(*)
	real pi

	pi=4.*atan(1.)

        do i=1,nt

        t=i*dt

        if(t.lt.pt)then
            s(i) = sin (rn*pi*t/pt) - (rn/(rn+2)) * sin ((rn+2)*pi*t/pt)
        endif

        enddo

c            N defines the number of relative extrem values


        return
	end subroutine source

