
	include 'fd2_deriv.f'

	subroutine fd_evolution

	use derivative

	include 'common.h'

	real, dimension (nx,nz) :: upi,erp,etp,rtemp
!hpf$	distribute (*,block), shadow(0,4) :: rtemp,upi,erp,etp

c global checks

	if(mod(it,icheck)==0)then
	write(*,*)' Values at it = ',it
	write(*,*)minval(up),' < u_p < ',maxval(up)
	write(*,*)minval(srp),' < s_rp < ',maxval(srp)
	write(*,*)minval(stp),' < s_tp < ',maxval(stp)
	endif

c calculate acceleration and stress(dotted)


c free surface

	forall (i=1:izfree-1)
	srp(:,izfree-i)=-srp(:,izfree-1+i)
	srp(:,nz-izfree+i)=-srp(:,nz-izfree+1-i)
	end forall

c symmetries at left and right boundaries

c made symmetric

	forall (i=1:izfree-1)
	stp(izfree-i,:)=stp(izfree-1+i,:)
	stp(nx-izfree+i,:)=stp(nx-izfree+1-i,:)
	end forall

	srp(izfree,:)=0.
	srp(nx-izfree+1,:)=0.
	

c (1) u_p

c d_r srp 

	call  pder(rtemp,srp,dr,nx,nz,2,-1,nop)
	upi=rtemp
	call  inter(rtemp,srp,nx,nz,2,-1)
	upi=upi+1./r1*3.*rtemp

c d_theta stp

	call  pder(rtemp,stp,dtheta,nx,nz,1,-1,nop)
	upi=upi+1./r1*rtemp
	call  inter(rtemp,stp,nx,nz,1,-1)
	upi=upi+1./r1*cot1*2.*rtemp

	upi=upi/rho

c add source(s)

	if(source_type==1)then
	upi(izfree+1,isz)=upi(izfree+1,isz)+so(it)
	endif

c extrapolate displacement

	up=up+upi*dt

c set rim 0

	forall(i=1:izfree-1)
	up(i,:)=0.
	up(nx+1-i,:)=0.
	up(:,i)=0.
	up(:,nz+1-i)=0.
	end forall


c free surface

	forall(i=1:izfree-1) 
	up(:,izfree-i)=up(:,izfree+i)
	up(:,nz-izfree+1+i)=up(:,nz-izfree+1-i)
	end forall

c symmetries at left and right boundaries

	forall (i=1:izfree-1)
	up(izfree-i,:) =-up(izfree+i,:)
	up(nx-izfree+1+i,:)=-up(nx-izfree+1-i,:)
	end forall

	up(izfree,:)=0.
	up(nx-izfree+1,:)=0.
	

c e_rp 

	call  pder(rtemp,up,dr,nx,nz,2,1,nop)
	erp=rtemp
	call  inter(rtemp,up,nx,nz,2,1)
	erp=erp-1./r2*rtemp
	erp=mu2*erp

c etp

	call  pder(rtemp,up,dtheta,nx,nz,1,1,nop)
	etp=1./r1*rtemp
	call  inter(rtemp,up,nx,nz,1,1)
	etp=etp-1./r1*rtemp*cot2
	etp=mu1*etp
	


	srp=srp+erp*dt
	stp=stp+etp*dt


c add source(s)

	if(source_type==2)then
	srp(izfree+1,isz)=srp(izfree+1,isz)+so(it)
	elseif(source_type==3)then
	stp(izfree+1,isz)=stp(izfree+1,isz)+so(it)
	endif

c set rim 0

	forall(i=1:izfree-1)
	srp(i,:)=0.
	srp(nx+1-i,:)=0.
	srp(:,i)=0.
	srp(:,nz+1-i)=0.
	stp(i,:)=0.
	stp(nx+1-i,:)=0.
	stp(:,i)=0.
	stp(:,nz+1-i)=0.
	end forall

	return
	end
