
	subroutine fd_check

	include 'common.h'

	write(*,*)' Begin check '




	write(*,*)' ----------------------------- '
	write(*,*)'        The set up  '
	write(*,*)' ----------------------------- '
	write(*,*)' '
	write(*,*)' seisfile    :  ',seisfile
	write(*,*)' modelfile    :  ',modelfile
	write(*,*)' recfile     :  ',recfile
	write(*,*)' '
	write(*,*)' nx		:  ',nx
	write(*,*)' nz		:  ',nz
	write(*,*)' time	:  ',time
	write(*,*)' nt		:  ',nt
	write(*,*)' nop		:  ',nop
	write(*,*)' '

c min/max space increments
	write(*,*)' dr(m)       :  ',dr
c angular increment
	dxmax=rmax*dtheta
	dxmin=(rmax-dmax)*dtheta
	write(*,*)'max darc(m)	:  ',dxmax
	write(*,*)'min darc(m)	:  ',dxmin

c time increment

c calculate dt from stability

	vmax=maxval( sqrt(mu1/rho) )
	dx=min(dxmin,dxmax,dr)
	dt=stab* dx/(sqrt(2.)*vmax)

	write(*,*)' dt(s)       :  ',dt
	write(*,*)' izfree      :  ',izfree
	write(*,*)' '
	write(*,*)' model_type  :  ',model_type
	write(*,*)' vs0(m/s)    :  ',vs0
	write(*,*)' rho0(kg/m3) :  ',rho0
	write(*,*)' '
	write(*,*)' izrec       :  ',izrec
	write(*,*)' sdepth      :  ',sdepth
	write(*,*)' act.depth   :  ',rmax-r1(1,isz)
	write(*,*)' isz         :  ',isz
	write(*,*)' T_dom(s)    :  ',aa
	write(*,*)' it0         :  ',it0
	write(*,*)' '
	write(*,*)' Max(vs1)     :  ',maxval(sqrt(mu1/rho))
	write(*,*)' Min(vs1)     :  ',minval(sqrt(mu1/rho))
	write(*,*)' Max(vs2)     :  ',maxval(sqrt(mu2/rho))
	write(*,*)' Min(vs2)     :  ',minval(sqrt(mu2/rho))
	write(*,*)' Max(rho)     :  ',maxval(rho)
	write(*,*)' Min(rho)     :  ',minval(rho)
	write(*,*)' '
	vmax=maxval(sqrt((mu1)/rho))
	write(*,*)' Stability factor (<1) :  ',sqrt(2.)*vmax*dt/dx
	write(*,*)' '
	write(*,*)' R,theta '
	write(*,*)minval(r1),' < r1 < ',maxval(r1)
	write(*,*)minval(r2),' < r2 < ',maxval(r2)
	write(*,*) minval(theta1),' < theta1 < ',maxval(theta1)
	write(*,*)minval(theta2),' < theta2 < ',maxval(theta2)
	write(*,*)' '
	write(*,*)' Physical boundaries '
	write(*,*)' Free surface r : ',r1(1,izfree)
	write(*,*)' CMB          r : ',r1(1,nz-izfree+1)
	write(*,*)' Left  boundary theta : ',theta1(izfree,1)
	write(*,*)' Right boundary theta : ',theta1(nx-izfree+1,1)
	write(*,*)' '



	write(*,*)' izrec           : ',izrec
	write(*,*)' isamp           : ',isamp
	write(*,*)' iout            : ',iout
	write(*,*)' '
	write(*,*)' '
	write(*,*)' icheck               : ',icheck
	write(*,*)' isnap               : ',isnap
	write(*,*)' '
	write(*,*) nr ,' Receiver locations '
	do i=1,nr
	write(*,*)' Receiver ',i,' at theta = ',rec_loc(i),'deg'
	enddo
	write(*,*)' '
	write(*,*)' '
	write(*,*)' '
	write(*,*)' Starting time loop for ...',nt,' time steps ... '
	write(*,*)' ... on ',number_of_processors(),' processors ... '
	write(*,*)' '
	write(*,*)' '

	write(*,*)' End check '

	return
	end
