c --------------------------------------------------------

	subroutine pder(g,h,f,dx,nx,nz,dir,dim,nop)

        real h  (nx,nz),f   (nx,nz)
        real sum(nx,nz),temp(nx,nz)
        real g(nop)
	integer dir,dim
	real dx

cmf$ layout  h    (:news,:news)
cmf$ layout  f    (:news,:news)
cmf$ layout  sum  (:news,:news)
cmf$ layout  temp (:news,:news)
cmf$ layout  g    (:serial)


C       Central term of convolution sum


	if(dir==1)then
	ig=nop/2
	else
	ig=nop/2+1
	endif

        sum = f*g(ig)/dx

C       Causal terms of convolution sum

        temp=f
        do j=ig+1,nop
                temp=cshift(temp,shift=1,dim=dim)
                sum=sum+g(j)/dx*temp
        enddo

C       Anti-causal terms of convolution sum

        temp=f
        do j=ig-1,1,-1
                temp=cshift(temp,shift=-1,dim=dim)
                sum=sum+g(j)/dx*temp
        enddo

        h=sum

        return
        end


c ----------------------------------------------

        subroutine CONVT(h,f,g,ig,nop,maxnt)

        real h  (maxnt),f   (maxnt)
        real sum(maxnt),temp(maxnt)
        real g(8)

cmf$ layout  h    (:news)
cmf$ layout  f    (:news)
cmf$ layout  sum  (:news)
cmf$ layout  temp (:news)
cmf$ layout  g    (:serial)


C       Central term of convolution sum

        sum = f*g(ig)

C       Causal terms of convolution sum

        temp=f
        do j=ig+1,nop
                temp=cshift(temp,shift=1,dim=1)
                sum=sum+g(j)*temp
        enddo

C       Anti-causal terms of convolution sum

        temp=f
        do j=ig-1,1,-1
                temp=cshift(temp,shift=-1,dim=1)
                sum=sum+g(j)*temp
        enddo

        h=sum

        return
        end
c --------------------------------------------------------

	subroutine inter(g,h,f,nx,nz,dir,dim,nop)

        real h  (nx,nz),f   (nx,nz)
        real sum(nx,nz),temp(nx,nz)
        real g(nop)
	integer dir,dim

cmf$ layout  h    (:news,:news)
cmf$ layout  f    (:news,:news)
cmf$ layout  sum  (:news,:news)
cmf$ layout  temp (:news,:news)
cmf$ layout  g    (:serial)


C       Central term of convolution sum


	if(dir==1)then
	ig=nop/2
	else
	ig=nop/2+1
	endif

        sum = f*g(ig)

C       Causal terms of convolution sum

        temp=f
        do j=ig+1,nop
                temp=cshift(temp,shift=1,dim=dim)
                sum=sum+g(j)*temp
        enddo

C       Anti-causal terms of convolution sum

        temp=f
        do j=ig-1,1,-1
                temp=cshift(temp,shift=-1,dim=dim)
                sum=sum+g(j)*temp
        enddo

        h=sum


        return
        end


