
c global specifiactions

	parameter(nx=500,nz=500)
	parameter(maxnt=1000)
	parameter(maxnr=100)
	parameter(pi=3.1415926535898)

c space variables

	real, dimension (nx,nz):: lam,mu,rho,window,tmp
	real, dimension (nx,nz):: w11,w12,w13,w14,w15
	real, dimension (nx,nz):: w21,w22,w23,w24,w25
	real rho0,vs0,vp0

!hpf$	template, dimension (nx,nz) :: t 
!hpf$	distribute (*,block) :: t 
!hpf$   align with t :: mu,lam,rho,window,tmp
!hpf$   align with t :: w11,w12,w13,w14,w15
!hpf$   align with t :: w21,w22,w23,w24,w25

c source 

	integer source_type
	real so(maxnt)
	integer isx,isz,ssamp

c seismograms

	real seisx(maxnr*maxnt)
	real seisz(maxnr*maxnt)

c FD

	real dx,dt

c Files

	character*50 seisfile,modelfile


	common /creal/ dx,dt,so,aa,vs0,vp0,rho0,mu,w,
     &                 lam,rho,w11,w12,w13,w14,w15,
     &                 w21,w22,w23,w24,w25,window

	common /cint/ nt,it,isx,isz,source_type,
     &                ixa,ixe,irec,isamp,izrec,it0,
     &	              model_type,icheck,ssamp,nabs,
     &	              icomp,isnap,nop,izfree,iout

	common /cchar/ seisfile,modelfile

