

	subroutine fd_evolution

	include 'fd2_deriv.h'
	include 'common.h'

	real rtemp(nx,nz)
!hpf$	align with t :: rtemp

c global checks

	w11=window*w11
	w12=window*w12

	if(mod(it,icheck)==0)then
	write(*,*)' Values at it = ',it
	write(*,*)minval(w11),' < v_x < ',maxval(w11)
	write(*,*)minval(w12),' < v_z < ',maxval(w12)
	write(*,*)minval(window),' < window < ',maxval(window)
c	write(*,*)minval(w13),' < s_11 < ',maxval(w13)
c	write(*,*)minval(w14),' < s_22 < ',maxval(w14)
c	write(*,*)minval(w15),' < s_12 < ',maxval(w15)
	endif

c add stress sources

	if(source_type==3)then
	w13=w13+gauss*so(it)
	w14=w14+gauss*so(it)
	endif


c calculate acceleration and stress(dotted)


c free surface

	if(nabs==0)then
	forall (i=1:nop/2-1) w14(:,izfree-i)=-w14(:,izfree+i)
	w14(:,izfree)=0.
	forall (i=1:nop/2-1) w15(:,izfree+1-i)=-w15(:,izfree+i)
	endif

c (1) vi_x

c der x

	call  pder(rtemp,w13,dx,nx,nz,1,-1,nop)

	w21=rtemp

c der z

	call  pder(rtemp,w15,dx,nx,nz,2,1,nop)

	w21=w21+rtemp
	w21=w21/rho*window

c (2) vi_z
	
c der x

	call  pder(rtemp,w15,dx,nx,nz,1,1,nop)

	w22=rtemp

c der z

	call  pder(rtemp,w14,dx,nx,nz,2,-1,nop)

	w22=w22+rtemp
	w22=w22/rho*window

c add source(s)

	if(source_type==1)then
	w21=w21+gauss*so(it)
	elseif(source_type==2)then
	w22=w22+gauss*so(it)
	endif

c extrapolate displacement

	w11=w11+w21*dt
	w12=w12+w22*dt

	if(nabs==0)then

c some boundaries

	w11(1:izfree-1,:)=0.
	w11(:,1:izfree-1)=0.
	w11(nx-izfree:nx,:)=0.
	w11(:,nz-izfree:nz)=0.

	w12(1:izfree,:)=0.
	w12(:,1:izfree-1)=0.
	w12(nx-izfree:nx,:)=0.
	w12(:,nz-izfree:nz)=0.


c free surface

	forall (i=1:nop/2-1) w11(:,izfree-i)=w11(:,izfree+i)
	forall (i=1:nop/2-1) w12(:,izfree+1-i)=w12(:,izfree+i)

	endif


c (3) sigma_11

c der x
	
	call  pder(rtemp,w11,dx,nx,nz,1,1,nop)

	w23=(lam+2*mu)*rtemp

c der z

	call  pder(rtemp,w12,dx,nx,nz,2,1,nop)

	w23=w23+lam*rtemp

c (4) sigma_22
	
c der z
	
c	call  pder(rtemp,w12,dx,nx,nz,2,1,nop)

	w24=(lam+2*mu)*rtemp

c der x

	call  pder(rtemp,w11,dx,nx,nz,1,1,nop)

	w24=w24+lam*rtemp


c (5) sigma_12

c der x
	
	call  pder(rtemp,w12,dx,nx,nz,1,-1,nop)

	w25=mu*rtemp

c der z

	call  pder(rtemp,w11,dx,nx,nz,2,-1,nop)

	w25=w25+mu*rtemp



c time extrapolation

	w13=w13+w23*dt*window
	w14=w14+w24*dt*window
	w15=w15+w25*dt*window

	return
	end
