
	subroutine ch_check

	include 'common.h'

	real ddx(0:nx)
	real ddz(0:nz)

	write(*,*)' Begin check '



	write(*,*)' ----------------------------- '
	write(*,*)'        The set up  '
	write(*,*)' ----------------------------- '
	write(*,*)' '
	write(*,*)' seisfile    :  ',seisfile
	write(*,*)' '
	write(*,*)' nx		:  ',nx
	write(*,*)' nz		:  ',nz
	write(*,*)' nt		:  ',nt
	write(*,*)' '
	write(*,*)' dt		:  ',dt
	write(*,*)' tord	:  ',tord
	write(*,*)' '
	write(*,*)' model_type  :  ',model_type
	write(*,*)' vs0         :  ',vs0
	write(*,*)' vp0         :  ',vp0
	write(*,*)' rho0        :  ',rho0
	write(*,*)' '
	write(*,*)' ixa          :  ',ixa
	write(*,*)' ixe          :  ',ixe
	write(*,*)' izrec       :  ',izrec
	write(*,*)' irec        :  ',irec
	write(*,*)' '
	write(*,*)' xxs         :  ',xxs
	write(*,*)' zzs         :  ',zzs
	write(*,*)' source_type :  ',source_type
	write(*,*)' aa          :  ',aa
	write(*,*)' alpha       :  ',alpha
	write(*,*)' it0         :  ',it0
	write(*,*)' ibound      :  ',ibound
	write(*,*)' '
	write(*,*)' Max(vs)     :  ',maxval(sqrt(mu/rho))
	write(*,*)' Min(vs)     :  ',minval(sqrt(mu/rho))
	write(*,*)' Max(vp)     :  ',maxval(sqrt((lam+2*mu)/rho))
	write(*,*)' Min(vp)     :  ',minval(sqrt((lam+2*mu)/rho))
	write(*,*)' Max(rho)     :  ',maxval(rho)
	write(*,*)' Min(rho)     :  ',minval(rho)
	write(*,*)' '

	ddx=abs(xs-cshift(xs,dim=1,shift=1))
	ddz=abs(zs-cshift(zs,dim=1,shift=1))
	ddxmin=minval(ddx(1:nx-1))
	ddxmax=maxval(ddx(1:nx-1))
	ddzmin=minval(ddz(1:nz-1))
	ddzmax=maxval(ddz(1:nz-1))

	write(*,*)ddxmin,' < dz < ',ddxmax
	write(*,*)ddzmin,' < dz < ',ddzmax

	write(*,*)' '
	write(*,*)' Max Stability factor (x):  ',
     &    maxval(sqrt((lam+2*mu)/rho))*dt/ddxmin
	write(*,*)' Max Stability factor (z):  ',
     &	maxval(sqrt((lam+2*mu)/rho))*dt/ddzmin
	write(*,*)' '
	write(*,*)' '
	write(*,*)' ixa           : ',ixa
	write(*,*)' ixe           : ',ixe
	write(*,*)' izrec           : ',izrec
	write(*,*)' isamp           : ',isamp
	write(*,*)' ssamp           : ',ssamp
	write(*,*)' '
	write(*,*)' icheck               : ',icheck
	write(*,*)' ibound               : ',ibound
	write(*,*)' '
	write(*,*)' Derivative operator '
	write(*,*)minval(dmx),' < dmx < ',maxval(dmx)
	write(*,*)minval(dmz),' < dmz < ',maxval(dmz)
	write(*,*)' '
	write(*,*)' Stretching '
	write(*,*)' istretch               : ',istretch
	write(*,*)' gammax   	     : ',gammax
	write(*,*)' gammaz   	     : ',gammaz
	write(*,*)' xmax   	     : ',xmax
	write(*,*)' zmax   	     : ',zmax
	write(*,*)' '
	write(*,*)' '
	write(*,*)' Receivers offsets : '

        nr=(ixe-ixa)/irec+1

	open(unit=50,file=seisfile(1:lnblnk(seisfile))//'_rec')
	write(50,*)nr

	do i=1,nr
        ixrec=ixa+(i-1)*irec
	write(*,*)' Receiver ',i,' : ',xs(ixrec)-xxs,'m' 
	write(50,*)xs(ixrec)-xxs
	enddo
	close(50)

	write(*,*)' '
	write(*,*)' Starting time loop for ...',nt,' time steps ... '
	write(*,*)' '
	write(*,*)' '

	write(*,*)' End check '

	return
	end
