
clear
close all

% Matlab program to visualize and process Blind Test Model 1 data (BTM1)

load stationnames

% filtering
nord=2;
flow=0.5; % Hz

z0=0.00
ns=length(files);
nt=4096;
dt=0.0150;
seis=zeros([3, ns, nt]);

time=(0:nt-1)*dt;

disp('---------------------------- ')
disp(' ')
disp(' SPICE Benchmark BTM1')
disp(' ')
disp(' -------------------------- ')


disp(' Please make choice of adjoint type ')
disp(' 1) Original ')
disp(' 2) Acceleration ')
ans1=input(' Which ? (1,2) ');
if ans1==1,c1=' Original ';end
if ans1==2,c1=' Acceleration ';end

disp(' Uniform weighting (0-no,1-yes) ')
ans2=input(' Which ? (0,1) ');
if ans2==0,c2=' no-weight ';end
if ans2==1,c2=' Uniform weighting ';end


disp(' High-pass? (0-no,1-yes) ')
ans3=input(' Which ? (0,1) ');

if ans3==1,
    disp(' Give lower limit in Hz (e.g., 0.5) ')
    flow=input(' Lower limit ? ');
end

if ans3==0,c3=' no-filt ';end
if ans3==1,c3=sprintf(' Highpass at %g Hz ',flow);end

% plot title
ctitle=sprintf('%s - %s - %s',c1,c2,c3);

disp(' Give name of directory to create adjoint sources (in single brackets) ')
cdir=input(' Directory? ') 
eval(['mkdir ' cdir]);

sprintf(' Plotting/processing the following %i data files ',ns)

for i=1:ns,
    
s=char(deblank(files(i,:)));
disp(sprintf(' %i  : %s ',i,char(deblank(files(i,:)))));
importfile(s);
disp(textdata);
seis(:,i,:)=data';

% resampling
ndt=.0075;
ntime=1:ndt:nt*dt;
nnt=length(ntime);

for ic=1:3,
    rseis(ic,i,:)=interp1(time,squeeze(seis(ic,i,:)),ntime);
end

disp(sprintf(' Resampled to %i time steps, dt = %g',nnt,ndt));

if i==1,
fidr=fopen(sprintf('%s/ad_srcfile_tottori',cdir),'w');
fprintf(fidr,'%i\n',ns);
end

% extract coordinates
coords=sscanf(char(textdata(3)), '%*s %*s %*s %g %*s %*s %*s %g');
xc(i)=coords(1)*1000.0;
yc(i)=coords(2)*1000.0;
fprintf(fidr,'%f %f %f\n',xc(i),yc(i),z0);

% Calculate epicentral distance
dist(i)=sqrt(xc(i)*xc(i)+yc(i)*yc(i));

% shorten and taper seismograms

            ntmax=5000;
            for ic=1:3
            rrseis(ic,i,:)=taper(squeeze(rseis(ic,i,1:ntmax)),-500);
       
            if ans1==2,
            disp(' Conversion to acceleration ')
            rrseis(ic,i,1:ntmax-1)=diff(squeeze(rrseis(ic,i,1:ntmax)))/ndt;
            rrseis(ic,i,ntmax)=0.*rrseis(ic,i,ntmax);
            end
            
            if ans3==1, 
                rrseis(ic,i,:)=highpass(rrseis(ic,i,:),ndt,flow,nord); 
                disp(sprintf(' Highpassing above %g Hz ',flow))
            end
            end
% output adjoint / time reverse source

% max for all three components
            
            rmax=1;      
            if ans2==1,
                disp(' Uniform weighting ')
                rmax=max(max(abs(rseis(1:3,i,1:ntmax))));
            end
            
            file=sprintf('%s/ad_src_x_%i',cdir,i);
            fida=fopen(file,'w');
            
            for it=1:ntmax,
                fprintf(fida,'%g\n',rrseis(1,i,ntmax+1-it)/rmax);
                asseis(1,i,it)=rrseis(1,i,ntmax+1-it)/rmax;
            end
            fclose(fida);

            file=sprintf('%s/ad_src_y_%i',cdir,i);
            fida=fopen(file,'w');
            for it=1:ntmax,
                fprintf(fida,'%g\n',rrseis(2,i,ntmax+1-it)/rmax);
                asseis(2,i,it)=rrseis(2,i,ntmax+1-it)/rmax;
            end
            fclose(fida);

            file=sprintf('%s/ad_src_z_%i',cdir,i);
            fida=fopen(file,'w');
            for it=1:ntmax,
                fprintf(fida,'%g\n',rrseis(3,i,ntmax+1-it)/rmax);
                asseis(3,i,it)=rrseis(3,i,ntmax+1-it)/rmax;
            end
            fclose(fida);

            
            % plot each station
            subplot(131), plot(ntime(1:ntmax),(i-1)+squeeze(asseis(1,i,1:ntmax))/max(asseis(1,i,1:ntmax))),ylabel(' x '),axis([-Inf Inf -1 ns+1])
            xlabel(' Time (s) ');
            ylabel(' Station number ');
            axis square
            hold on
            subplot(132), plot(ntime(1:ntmax),(i-1)+squeeze(asseis(2,i,1:ntmax))/max(asseis(2,i,1:ntmax))),ylabel(' y '),axis([-Inf Inf -1 ns+1])
            xlabel(' Time (s) ')
            axis square
            title(ctitle);
            hold on
            subplot(133), plot(ntime(1:ntmax),(i-1)+squeeze(asseis(3,i,1:ntmax))/max(asseis(3,i,1:ntmax))),ylabel(' z '),axis([-Inf Inf -1 ns+1])
            axis square
            hold on
            xlabel(' Time (s) ')
            drawnow

end

cplot=sprintf('%s/adj_source.jpg',cdir);
eval(['print -djpeg100 ' cplot]);

fclose(fidr)