function  fx=highpass(x,dt,fup,n)
% function  fx=highpass(x,dt,fup,n)
% Simple lowpass filtering 0-phase using butterworth
% x input vector
% dt sampling rate
% fup cutoff frequency
% n order
fN=1/(2*dt);
w=fup/fN;
[B,A] = BUTTER(n,w,'high');
fx = FILTFILT(B, A, x);
% end
