!*****************************************************************************
!***************** Interpolation & FD partial derivatives in 3D **************
!******************* for different operator lengths ****** *******************
!*****************************************************************************

! Interpolation 

SUBROUTINE inter(o,f,comp,dir)

        IMPLICIT NONE
        INCLUDE 'common_global.h'

	REAL, DIMENSION(0:nx,0:ny,0:nz), INTENT(in)  :: f
	REAL, DIMENSION(0:nx,0:ny,0:nz), INTENT(out) :: o

	CHARACTER*1 dir,comp

	o=0.

	IF ( comp == 'x' ) THEN

	    IF ( dir == '-' )THEN

		DO i=1,nx
		  o(i,:,:)=(f(i,:,:)+f(i-1,:,:))*.5
		ENDDO
	        o(0,:,:)=0.

	    ELSEIF( dir == '+' )THEN

		DO i=0,nx-1
		  o(i,:,:)=(f(i+1,:,:)+f(i,:,:))*.5
		ENDDO
	        o(nx,:,:)=0.

	    ENDIF

	ELSEIF( comp == 'y' ) THEN

	    IF ( dir == '-' ) THEN

		DO j=1,ny
		  o(:,j,:)=(f(:,j,:)+f(:,j-1,:))*.5
		ENDDO
		o(:,0,:)=0.

	    ELSEIF( dir == '+' )THEN

		DO j=0,ny-1
		  o(:,j,:)=(f(:,j+1,:)+f(:,j,:))*.5
		ENDDO
		o(:,ny,:)=0.

	    ENDIF

	ELSEIF( comp == 'z') THEN

	    IF ( dir == '-' ) THEN

		DO k=1,nz
      		  o(:,:,k)=(f(:,:,k)+f(:,:,k-1))*.5
		ENDDO
		o(:,:,0)=0.

	    ELSEIF( dir == '+')THEN

		DO k=0,nz-1
		  o(:,:,k)=(f(:,:,k+1)+f(:,:,k))*.5
		ENDDO
		o(:,:,nz)=0.

	    ENDIF

	ENDIF
	

END SUBROUTINE inter


!=============================================================================


! FD method: partial derivatives for different operator lengths (2<->8)

SUBROUTINE pder(h,f,comp,dir)

        IMPLICIT NONE
	INCLUDE 'common_global.h'

	REAL, DIMENSION(0:nx,0:ny,0:nz), INTENT(in) :: f
	REAL, DIMENSION(0:nx,0:ny,0:nz), INTENT(out) :: h
        
        CHARACTER*1 dir,comp

! the symmetry

         DO i=nop/2+1,nop
          g(i) = -g(nop-i+1)
         ENDDO

	IF ( comp == 'x' ) THEN

	    IF ( dir == '-' )THEN

		IF(nop==2)THEN
		DO i=1,nx
		  h(i,:,:)=(f(i,:,:)-f(i-1,:,:))*dxinv	
		ENDDO
		h(0,:,:)=0.
		ENDIF		

		IF(nop==4)THEN
		DO i=2,nx-1
	       	  h(i,:,:)=(g(1)*f(i-2,:,:)+ &
     		           g(2)*f(i-1,:,:)+ &
     		           g(3)*f(i  ,:,:)+ &
     		           g(4)*f(i+1,:,:))*dxinv
		ENDDO
		h(0:1,:,:)=0.
		h(nx,:,:) =0.
		ENDIF		

		IF(nop==8)THEN
		DO i=4,nx-3
		  h(i,:,:)=(g(1)*f(i-4,:,:)+ &
     		            g(2)*f(i-3,:,:)+ &
     		            g(3)*f(i-2,:,:)+ &
     		            g(4)*f(i-1,:,:)+ &
     		            g(5)*f(i  ,:,:)+ &
     		            g(6)*f(i+1,:,:)+ &
     		            g(7)*f(i+2,:,:)+ &
     		            g(8)*f(i+3,:,:))*dxinv 
		ENDDO
		h(0:3,:,:)=0.		
		h(nx-2:nx,:,:)=0.		
		ENDIF		

	ELSEIF( dir == '+' )THEN

		IF(nop==2)THEN
		DO i=0,nx-1
		  h(i,:,:)=(f(i+1,:,:)-f(i,:,:))*dxinv	
		ENDDO
		h(nx,:,:)=0.
		ENDIF


		IF(nop==4)THEN
		DO i=1,nx-2
		  h(i,:,:)=(g(1)*f(i-1,:,:)+ &
     		            g(2)*f(i,  :,:)+ &
     		            g(3)*f(i+1,:,:)+ &
     		            g(4)*f(i+2,:,:))*dxinv 
		ENDDO
		h(0,:,:)=0.
		h(nx-1:nx,:,:)=0.
		ENDIF		

		IF(nop==8)THEN
		DO i=3,nx-4
		  h(i,:,:)=(g(1)*f(i-3,:,:)+ &
     		            g(2)*f(i-2,:,:)+ &
     		            g(3)*f(i-1,:,:)+ &
     		            g(4)*f(i  ,:,:)+ &
     		            g(5)*f(i+1,:,:)+ &
     		            g(6)*f(i+2,:,:)+ &
     		            g(7)*f(i+3,:,:)+ &
     		            g(8)*f(i+4,:,:))*dxinv 
		ENDDO
		h(0:2,:,:)=0.
		h(nx-3:nx,:,:)=0.
		ENDIF		

	ENDIF

	ELSEIF( comp == 'y' ) THEN

	    IF ( dir == '-' ) THEN

		IF(nop==2)THEN
		DO j=1,ny
		  h(:,j,:)=(f(:,j,:)-f(:,j-1,:))*dyinv	
		ENDDO
		h(:,0,:)=0.
		ENDIF		

		IF(nop==4)THEN
		DO j=2,ny-1
		  h(:,j,:)=(g(1)*f(:,j-2,:)+ &
     		            g(2)*f(:,j-1,:)+ &
     		            g(3)*f(:,j,  :)+ &
     		            g(4)*f(:,j+1,:))*dyinv 
		ENDDO
		h(:,0:1,:)=0.
		h(:,ny,:)=0.
		ENDIF		

		IF(nop==8)THEN
		DO j=4,ny-3
		h(:,j,:)=(g(1)*f(:,j-4,:)+ &
     		          g(2)*f(:,j-3,:)+ &
     		          g(3)*f(:,j-2,:)+ &
     		          g(4)*f(:,j-1,:)+ &
     		          g(5)*f(:,j,  :)+ &
     		          g(6)*f(:,j+1,:)+ &
     		          g(7)*f(:,j+2,:)+ &
     		          g(8)*f(:,j+3,:))*dyinv 
		ENDDO
		h(:,0:3,:)=0.
		h(:,ny-2:ny,:)=0.
		ENDIF		

	ELSEIF( dir == '+' )THEN

		IF(nop==2)THEN
		DO j=0,ny-1
		  h(:,j,:)=(f(:,j+1,:)-f(:,j,:))*dyinv	
		ENDDO
		h(:,ny,:)=0.
		ENDIF


		IF(nop==4)THEN
		DO j=1,ny-2
		  h(:,j,:)=(g(1)*f(:,j-1,:)+ &
     		            g(2)*f(:,j,  :)+ &
     		            g(3)*f(:,j+1,:)+ &
     		            g(4)*f(:,j+2,:))*dyinv 
		ENDDO
		h(:,0,:)=0.
		h(:,ny-1:ny,:)=0.
		ENDIF		

		IF(nop==8)THEN
		DO j=3,ny-4
		  h(:,j,:)=(g(1)*f(:,j-3,:)+ &
     		            g(2)*f(:,j-2,:)+ &
     		            g(3)*f(:,j-1,:)+ &
     		            g(4)*f(:,j,  :)+ &
     		            g(5)*f(:,j+1,:)+ &
     		            g(6)*f(:,j+2,:)+ &
     		            g(7)*f(:,j+3,:)+ &
     		            g(8)*f(:,j+4,:))*dyinv 
		ENDDO
		h(:,0:2,:)=0.
		h(:,ny-3:ny,:)=0.
		ENDIF		

	    ENDIF

	ELSEIF( comp == 'z') THEN

	    IF ( dir == '-' ) THEN

		IF(nop==2)THEN
		DO k=1,nz
		  h(:,:,k)=(f(:,:,k)-f(:,:,k-1))*dzinv	
		ENDDO
		h(:,:,0)=0.
		ENDIF		

		IF(nop==4)THEN
		DO k=2,nz-1
		  h(:,:,k)=(g(1)*f(:,:,k-2)+ &
     		            g(2)*f(:,:,k-1)+ &
     		            g(3)*f(:,:,k  )+ &
     		            g(4)*f(:,:,k+1))*dzinv 
	        ENDDO
		h(:,:,0:1)=0.
		h(:,:,nz)=0.
		ENDIF		

		IF(nop==8)THEN
		DO k=4,nz-3
		  h(:,:,k)=(g(1)*f(:,:,k-4)+ &
     		            g(2)*f(:,:,k-3)+ &
     		            g(3)*f(:,:,k-2)+ &
     		            g(4)*f(:,:,k-1)+ &
     		            g(5)*f(:,:,k  )+ &
     		            g(6)*f(:,:,k+1)+ &
     		            g(7)*f(:,:,k+2)+ &
     		            g(8)*f(:,:,k+3))*dzinv 
		ENDDO
		h(:,:,0:3)=0.
		h(:,:,nz-2:nz)=0.
		ENDIF		

	ELSEIF( dir == '+')THEN

		IF(nop==2)THEN
		DO k=0,nz-1
		  h(:,:,k)=(f(:,:,k+1)-f(:,:,k))*dzinv	
		ENDDO
		h(:,:,nz)=0.
		ENDIF


		IF(nop==4)THEN
		DO k=1,nz-2
		  h(:,:,k)=(g(1)*f(:,:,k-1)+ &
     		            g(2)*f(:,:,k  )+ &
     		            g(3)*f(:,:,k+1)+ &
     		            g(4)*f(:,:,k+2))*dzinv 
		ENDDO
		h(:,:,0)=0.
		h(:,:,nz-1:nz)=0.
		ENDIF		

		IF(nop==8)THEN
		DO k=3,nz-4
		  h(:,:,k)=(g(1)*f(:,:,k-3)+ &
     		            g(2)*f(:,:,k-2)+ &
     		            g(3)*f(:,:,k-1)+ &
     		            g(4)*f(:,:,k  )+ &
     		            g(5)*f(:,:,k+1)+ &
     		            g(6)*f(:,:,k+2)+ &
     		            g(7)*f(:,:,k+3)+ &
     		            g(8)*f(:,:,k+4))*dzinv 
		ENDDO
		h(:,:,0:2)=0.
		h(:,:,nz-3:nz)=0.
		ENDIF		

	    ENDIF

	ENDIF
	
END SUBROUTINE pder

!=============================================================================
