!*****************************************************************************
!***************** FD time evolution and spatial derivatives******************
!*****************************************************************************

SUBROUTINE fd3s_evolution

        IMPLICIT NONE
        INCLUDE 'common_global.h'

        REAL exx(0:nx,0:ny,0:nz)      ! Temporary 3d-variables for computation 
        REAL eyy(0:nx,0:ny,0:nz)      ! of derivatives and interpolation 
        REAL ezz(0:nx,0:ny,0:nz)      ! CAUTION:
        REAL exy(0:nx,0:ny,0:nz)      ! Variables take different 
        REAL tmp1(0:nx,0:ny,0:nz)     ! jobs within subroutine.
        REAL tmp2(0:nx,0:ny,0:nz)     ! Not always linked with their names
        REAL tmp3(0:nx,0:ny,0:nz)
        REAL tmp4(0:nx,0:ny,0:nz)


! global checks of max./min field values

     IF(MOD(it,icheck)==0)THEN

        WRITE(*,*)''
        WRITE(*,*)' Values at it = ',it
        WRITE(*,*)MINVAL(w13),' < vz  < ',MAXVAL(w13)

        WRITE(99,*)''
        WRITE(99,*)' Values at it = ',it
        WRITE(99,*)MINVAL(w11),' < vx  < ',MAXVAL(w11)
        WRITE(99,*)MINVAL(w12),' < vy  < ',MAXVAL(w12)
        WRITE(99,*)MINVAL(w13),' < vz  < ',MAXVAL(w13)
        WRITE(99,*)MINVAL(w14),' < sxx < ',MAXVAL(w14)
        WRITE(99,*)MINVAL(w15),' < syy < ',MAXVAL(w15)
        WRITE(99,*)MINVAL(w16),' < szz < ',MAXVAL(w16)
        WRITE(99,*)MINVAL(w17),' < sxy < ',MAXVAL(w17)
        WRITE(99,*)MINVAL(w18),' < sxz < ',MAXVAL(w18)
        WRITE(99,*)MINVAL(w19),' < syz < ',MAXVAL(w19)
        WRITE(99,*)MINVAL(divx),' < DIV_x < ',MAXVAL(divx)
        WRITE(99,*)MINVAL(rotx),' < ROT_x < ',MAXVAL(rotx)
        WRITE(99,*)MINVAL(divy),' < DIV_y < ',MAXVAL(divy)
        WRITE(99,*)MINVAL(roty),' < ROT_y < ',MAXVAL(roty)
        WRITE(99,*)MINVAL(divsurf),' < DIV_surf < ',MAXVAL(divsurf)
        WRITE(99,*)MINVAL(rotsurf),' < ROT_surf < ',MAXVAL(rotsurf)

     ENDIF

!=============================================================================

! taper velocity wavefield

        w11=window*w11
        w12=window*w12
        w13=window*w13

!=============================================================================

! add source(s)

! Explosion

    IF(source_type==4)THEN   
        IF (alpha .EQ. 0) THEN
         w14(isx,isy,isz)=w14(isx,isy,isz)+so(it)
         w15(isx,isy,isz)=w15(isx,isy,isz)+so(it)
         w16(isx,isy,isz)=w16(isx,isy,isz)+so(it)

        ELSE
         w14=w14+gauss*so(it)                       ! for spatial gauss sources
         w15=w15+gauss*so(it)
         w16=w16+gauss*so(it)
        ENDIF

! Moment tensor source 

    ELSEIF(source_type==10)THEN   
      IF (alpha .EQ. 0) THEN

       w14(isx,isy,isz)=w14(isx,isy,isz)+moment(4)*so(it)        
       w15(isx,isy,isz)=w15(isx,isy,isz)+moment(5)*so(it)
       w16(isx,isy,isz)=w16(isx,isy,isz)+moment(6)*so(it)
       w17(isx,isy,isz)=w17(isx,isy,isz)+moment(7)*so(it)
       w18(isx,isy,isz)=w18(isx,isy,isz)+moment(8)*so(it)
       w19(isx,isy,isz)=w19(isx,isy,isz)+moment(9)*so(it)

      ELSE
        w14=w14+moment(4)*gauss*so(it)              ! for spatial gauss sources
        w15=w15+moment(5)*gauss*so(it)
        w16=w16+moment(6)*gauss*so(it)
        w17=w17+moment(7)*gauss*so(it)
        w18=w18+moment(8)*gauss*so(it)
        w19=w19+moment(9)*gauss*so(it)
      ENDIF

    ENDIF ! moment tensor source


!=============================================================================

! free surface boundary conditions for stress tensor elements:
! antisymmetry condition for sigma_rr, sigma_(r,phi), sigma_(r,theta)


       w16(:,:,izfree)=0.
       DO i=1,izfree
         w16(:,:,izfree-i)=-w16(:,:,izfree+i)
         w18(:,:,izfree-i)=-w18(:,:,izfree-1+i)
         w19(:,:,izfree-i)=-w19(:,:,izfree-1+i)
       ENDDO



!=============================================================================

! calculate acceleration from stresses

! d/dt(v_theta)*rho  (equal to w21 here)

    CALL pder(exx,w14,'x','+')     ! derivatives d/dtheta of s_theta,theta
    CALL pder(eyy,w17,'y','-')     ! derivatives d/dphi of s_theta,phi
    CALL pder(ezz,w18,'z','-')     ! derivatives d/dr of s_theta,r
    CALL inter(tmp1,w14,'x','+')   ! interpolate s_(theta,theta) for v_theta
    CALL inter(tmp2,w15,'x','+')   ! interpolate s_(phi,phi) for v_theta
    CALL inter(tmp3,w18,'z','-')   ! interpolate s_(r,theta) for v_theta

    DO iz=0,nz
     w21(:,:,iz) = ezz(:,:,iz) + 1/zs(iz)*exx(:,:,iz) + &
                   1/zs(iz)*sininv2(:,:,iz)*eyy(:,:,iz) + &
                   1/zs(iz)*((tmp1(:,:,iz)-tmp2(:,:,iz))*cottheta2(:,:,iz)+ &
                   3.*tmp3(:,:,iz)) 
    ENDDO


! d/dt(v_phi)*rho (equal to w22 here)
        
    CALL pder(exx,w17,'x','-')     ! derivatives d/dtheta of s_phi,theta
    CALL pder(eyy,w15,'y','+')     ! derivatives d/dphi of s_phi,phi
    CALL pder(ezz,w19,'z','-')     ! derivatives d/dr of s_phi,r
    CALL inter(tmp1,w19,'z','-')   ! interpolate s_r,phi for v_phi
    CALL inter(tmp2,w17,'x','-')   ! interpolate s_theta,phi for v_phi
        
    DO iz=0,nz     
     w22(:,:,iz) = ezz(:,:,iz) + 1/zs(iz)*exx(:,:,iz) + &
                   1/zs(iz)*sininv1(:,:,iz)*eyy(:,:,iz) + &
                   1/zs(iz)*(3.*tmp1(:,:,iz) + &
                   2.*cottheta1(:,:,iz)*tmp2(:,:,iz))
    ENDDO


! d/dt(v_r)*rho (equal to w23 here)
        
    CALL pder(exx,w18,'x','-')     ! derivatives d/dtheta of s_r,theta
    CALL pder(eyy,w19,'y','-')     ! derivatives d/dphi of s_r,phi
    CALL pder(ezz,w16,'z','+')     ! derivatives d/dr of s_r,r
    CALL inter(tmp1,w14,'z','+')   ! interpolate s_theta,theta for v_r
    CALL inter(tmp2,w15,'z','+')   ! interpolate s_phi,phi for v_r
    CALL inter(tmp3,w16,'z','+')   ! interpolate s_r,r for v_r
    CALL inter(tmp4,w18,'x','-')   ! interpolate s_r,theta for v_r

    DO iz=0,nz 
     w23(:,:,iz)  = ezz(:,:,iz)  + 1/(zs(iz)-dz/2)*exx(:,:,iz)  + &
                    1/(zs(iz)-dz/2)*sininv1(:,:,iz) *eyy(:,:,iz) +  &  
                    1/(zs(iz)-dz/2)*(2.*tmp3(:,:,iz) -tmp1(:,:,iz) - &
                    tmp2(:,:,iz) + cottheta1(:,:,iz) *tmp4(:,:,iz) )
    ENDDO


!=============================================================================

! multiply by 1/rho and taper accelerations at boundaries     

    IF (elast_inter==1) THEN 
      
    ! Interpolate density towards grid points of velocity components

     CALL inter(tmp1,rhoinv,'x','+')
     CALL inter(tmp2,rhoinv,'y','+')
     CALL inter(tmp3,rhoinv,'z','+')

     w21=tmp1*w21*window
     w22=tmp2*w22*window
     w23=tmp3*w23*window       

! Without density interpolation

    ELSE 
     w21=rhoinv*w21*window
     w22=rhoinv*w22*window
     w23=rhoinv*w23*window 
      
    ENDIF


!=============================================================================

! 2-order time extrapolation of velocities

    w11=w11+w21*dt
    w12=w12+w22*dt
    w13=w13+w23*dt


!=============================================================================

! single forces as source
         
    IF (alpha .EQ. 0) THEN

! For point sources
        
        IF(source_type==1)THEN                       ! Theta single force
          w11(isx,isy,isz)=w11(isx,isy,isz)+so(it)
        ELSEIF(source_type==2)THEN                   ! Phi single force
          w12(isx,isy,isz)=w12(isx,isy,isz)+so(it)
        ELSEIF(source_type==3)THEN                   ! Vertical single force
          w13(isx,isy,isz)=w13(isx,isy,isz)+so(it)
        ENDIF

! for gaussian sources
 
    ELSE                
      IF(source_type==1)THEN                         ! Theta single force  
        w11=w11+gauss*so(it)
      ELSEIF(source_type==2)THEN                     ! Phi single force
       w12=w12+gauss*so(it)
      ELSEIF(source_type==3)THEN                     ! Vertical single force 
       w13=w13+gauss*so(it)
      ENDIF        
    ENDIF


!=============================================================================

! free surface velocity components
 
! Model 1 (Symm), symmetry relations

     IF (fs_model==0) THEN 

      DO i=1,izfree
         w11(:,:,izfree-i)=w11(:,:,izfree+i)
         w12(:,:,izfree-i)=w12(:,:,izfree+i)
         w13(:,:,izfree-i)=w13(:,:,izfree-1+i)
      ENDDO
 
! Model 2 (Graves), differential equations 
        
    ELSEIF (fs_model==1) THEN

      CALL fs_graves(w11(:,:,izfree-1),w12(:,:,izfree-1),w13(:,:,izfree-1))  

     ENDIF

!=============================================================================

! calculate the strain rate from spatial derivatives of new velocities

! d/dt(e_theta,theta) (equal to exx here)

    CALL pder(w21,w11,'x','-')
    CALL inter(tmp1,w13,'z','-')
 
    DO iz=0,nz
     exx(:,:,iz)=1/zs(iz)*(w21(:,:,iz)+tmp1(:,:,iz))
    ENDDO


! d/dt(e_phi,phi) (equal to eyy here)

    CALL pder(w22,w12,'y','-')
    CALL inter(tmp2,w11,'x','-')

    DO iz=0,nz 
     eyy(:,:,iz)=1/zs(iz)*(sininv1(:,:,iz)*w22(:,:,iz)+tmp1(:,:,iz)+ &
                   cottheta1(:,:,iz)*tmp2(:,:,iz))
    ENDDO


! d/dt(e_r,r) (equal to ezz here) 

    CALL pder(ezz,w13,'z','-')


!=============================================================================

! ezz in free surface calculated via 2nd order derivative

           ezz(:,:,izfree)=(w13(:,:,izfree)-w13(:,:,izfree-1))*dzinv	

!=============================================================================

    IF (rotdiv==1) THEN

! Calculate Divergence of velocity field 

! surface
 
        divsurf=1/zs(izfree)*(2*tmp1(:,:,izfree)+zs(izfree)*ezz(:,:,izfree)+ &
            cottheta1(:,:,izfree)*w11(:,:,izfree)+w21(:,:,izfree)+ &
            sininv1(:,:,izfree)*w22(:,:,izfree)) 

     DO iz=0,nz

! r-phi cross section through hypocenter

      divx(:,iz)=1/zs(iz)*(2*tmp1(iplanex,:,iz)+zs(iz)*ezz(iplanex,:,iz)+ &
          cottheta1(iplanex,:,iz)*w11(iplanex,:,iz)+w21(iplanex,:,iz)+ &
          sininv1(iplanex,:,iz)*w22(iplanex,:,iz))

! r-theta cross section through hypocenter 

      divy(:,iz)=1/zs(iz)*(2*tmp1(:,iplaney,iz)+zs(iz)*ezz(:,iplaney,iz)+ &
          cottheta1(:,iplaney,iz)*w11(:,iplaney,iz)+w21(:,iplaney,iz)+ &
          sininv1(:,iplaney,iz)*w22(:,iplaney,iz)) 
 
    ENDDO

   ENDIF


!=============================================================================

! d/dt(e_theta,phi) (equal to exy here)

    CALL pder(w21,w11,'y','+')
    CALL pder(w22,w12,'x','+')
    CALL inter(tmp1,w12,'x','+')

    DO iz=0,nz 
     exy(:,:,iz)=.5*1/zs(iz)*(sininv2(:,:,iz)*w21(:,:,iz)+w22(:,:,iz)- &
                 cottheta2(:,:,iz)*tmp1(:,:,iz))  
    ENDDO
 

! d/dt(e_theta,r) first part

    CALL pder(w23,w11,'z','+')
    CALL pder(tmp3,w13,'x','+')   
    CALL inter(tmp1,w11,'z','+')
 
    CALL pder(tmp2,w12,'z','+')   ! For e_phi,r already (also for curl)
    CALL pder(tmp4,w13,'y','+')   ! For e_phi,r already (also for curl)

!=============================================================================

! Calculate Curl of velocities (component perpendicular to respective plane)

    IF (rotdiv==1) THEN
 
! surface

       rotsurf=1/zs(izfree)* &
         (w12(:,:,izfree)*cottheta1(:,:,izfree) + &
          w22(:,:,izfree)-sininv1(:,:,izfree)*w21(:,:,izfree)) 

     DO iz=0,nz

! r-phi cross section through hypocenter

      rotx(:,iz)=1/zs(iz)* &
         (sininv1(iplanex,:,iz)*tmp4(iplanex,:,iz)- &
          w12(iplanex,:,iz)-zs(iz)*tmp2(iplanex,:,iz)) 

! r-theta cross section through hypocenter

      roty(:,iz)=1/zs(iz)* &
         (w11(:,iplaney,iz)+zs(iz)*w23(:,iplaney,iz)- &
          tmp3(:,iplaney,iz))

     ENDDO
 
    ENDIF

!=============================================================================

! Continuation d/dt(e_theta,r) (equal to tmp3 here)
  
    DO iz=0,nz  
      tmp3(:,:,iz)=.5*(1/(zs(iz)-dz/2)*tmp3(:,:,iz)+w23(:,:,iz)- &
                   1/(zs(iz)-dz/2)*tmp1(:,:,iz))      
    ENDDO


! d/dt(e_phi,r) (equal to tmp4 here)

    ! tmp4=d/d_y(v_z) already calculated (due to rotation)
    ! tmp2=d/d_z(v_y) already calculated (due to rotation)      
        
    CALL inter(tmp1,w12,'z','+')

    DO iz=0,nz
      tmp4(:,:,iz)=.5*(1/(zs(iz)-dz/2)*sininv1(:,:,iz)*tmp4(:,:,iz)+ &
                   tmp2(:,:,iz)-1/(zs(iz)-dz/2)*tmp1(:,:,iz))
    ENDDO


!=============================================================================

! Hookes Law & final second order time extrapolation (stress)

! Normal stresses (Located in same grid points as Lame's Parameters)

    w14=w14+(lam*(exx+eyy+ezz) + 2*mu*exx) * window*dt
    w15=w15+(lam*(exx+eyy+ezz) + 2*mu*eyy) * window*dt
    w16=w16+(lam*(exx+eyy+ezz) + 2*mu*ezz) * window*dt


! Shear stresses: Interpolation of mu for respective grid points

    IF (elast_inter== 1) THEN       

!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! Interpolation of mu values as the mean value of four horizontally 
! adjacent values for e_theta,phi  

      CALL inter(exx,mu,'x','+')
      CALL inter(eyy,exx,'y','+')
      CALL inter(ezz,mu,'y','+')

      eyy=(mu+exx+eyy+ezz)*0.25   ! mean value

! extrapolation of strain rate e_theta,phi to stress s_theta,phi

      w17=w17+(2*eyy*exy) * window*dt

!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! Interpolation of mu values as the mean value of four adjacent values 
! in the r-theta plane for e_(r,theta)

      CALL inter(w21,exx,'z','+') ! exx from previous interpolation
      CALL inter(w22,mu,'z','+')

      eyy=(mu+exx+w21+w22)*0.25  ! mean value

! special treatment for free surface and lowermost grid point of each node   
! since the above interpolation would include points outside the model space

      eyy(0:nx-1,:,nz)=(mu(0:nx-1,:,nz)+mu(1:nx,:,nz))*0.5
      eyy(0:nx-1,:,0)=(mu(0:nx-1,:,0)+mu(1:nx,:,0))*0.5  

! extrapolation of strain rate e_r,theta to stress s_r,theta

      w18=w18+(2*eyy*tmp3) * window*dt


!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! Interpolation of mu values as the mean value of four adjacent values 
! in the r-phi plane for e_(r,phi)

      CALL inter(eyy,ezz,'z','+') ! ezz from the first elastic interpolation 

      eyy=(mu+ezz+eyy+w22)*0.25   ! mean value
                                  ! eyy & w22 from the previous interpolation

! special treatment for free surface and lowermost grid point of each node   
! since the above interpolation would include points outside the model space

      eyy(:,0:ny-1,nz)=(mu(:,0:ny-1,nz)+mu(:,1:ny,nz))*0.5
      eyy(:,0:ny-1,0)=(mu(:,0:ny-1,0)+mu(:,1:ny,0))*0.5 

! extrapolation of strain rate e_r,phi to stress s_r,phi

      w19=w19+(2*eyy*tmp4) * window*dt


!=============================================================================

    ELSE 

! Hooke's law and time extrapolation without elastic interpolation 

      w17=w17+(2*mu*exy) *window *dt
      w18=w18+(2*mu*tmp3) *window*dt
      w19=w19+(2*mu*tmp4) *window*dt

    ENDIF  ! elastic interpolation switch


!=============================================================================

! Free surface of normal stresses
       
      w14(:,:,0:izfree-1)=0.
      w15(:,:,0:izfree-1)=0.
      w16(:,:,0:izfree-1)=0.

!=============================================================================

    CONTAINS

    INCLUDE 'fd3s_oper.f90'

END SUBROUTINE fd3s_evolution



!########### Additional subroutines ##########################################

! Free surface after Graves

SUBROUTINE fs_graves(fs_x,fs_y,fs_z)

    IMPLICIT NONE
    INCLUDE 'common_global.h'
 
    REAL fs_x(0:nx,0:ny),fs_y(0:nx,0:ny),fs_z(0:nx,0:ny)
    REAL out1(0:nx,0:ny),out2(0:nx,0:ny)

! Vertical Component dz/2 above free surface

    CALL pder2(out1,w11(:,:,izfree),'-','x')
    CALL pder2(out2,w12(:,:,izfree),'-','y')

    fs_z=eta*(out1+sininv1(:,:,izfree)*out2+cottheta1(:,:,izfree)* &
         w12(:,:,izfree) + xi*w13(:,:,izfree))    ! CHANGED: w12 instead w11

! Theta-Component dz above free surface

    CALL pder2(out1,w13(:,:,izfree),'+','x')
    CALL pder2(out2,fs_z,'+','x')

    fs_x=alph*out1+beta*out2+gamma*w11(:,:,izfree+1)+delta*w11(:,:,izfree)


! Phi-Component dz above free surface

    CALL pder2(out1,w13(:,:,izfree),'+','y')
    CALL pder2(out2,fs_z,'+','y')

    fs_y=sininv1(:,:,izfree)*(alph*out1+beta*out2)+gamma* &
         w12(:,:,izfree+1)+delta*w12(:,:,izfree)

    RETURN

END SUBROUTINE fs_graves


!#############################################################################

! subroutine for partial FD derivatives in 2D , particularly for the surface

SUBROUTINE pder2(h2,f2,dir,comp)

    IMPLICIT NONE
    INCLUDE 'common_global.h'

    REAL, DIMENSION(0:nx,0:ny), INTENT(in) :: f2
    REAL, DIMENSION(0:nx,0:ny), INTENT(out) :: h2        
    CHARACTER*1 dir,comp

    IF ( comp == 'x' ) THEN         ! spatial dimension of derivative 
       IF ( dir == '-' )THEN        ! direction of difference operator 

		IF(nop==2)THEN      ! 2-point operator
		DO i=1,nx
		  h2(i,:)=(f2(i,:)-f2(i-1,:))*dxinv	
		ENDDO
		h2(0,:)=0.
		ENDIF		

		IF(nop==4)THEN     ! 4-point operator
		DO i=2,nx-1
	       	  h2(i,:)=(g(1)*f2(i-2,:)+ &
     		           g(2)*f2(i-1,:)+ &
     		           g(3)*f2(i,:)+ &
     		           g(4)*f2(i+1,:))*dxinv
		ENDDO
		h2(0:1,:)=0.
		h2(nx,:) =0.
		ENDIF		

		IF(nop==8)THEN     ! 8-point operator
		DO i=4,nx-3
		  h2(i,:)=(g(1)*f2(i-4,:)+ &
     		            g(2)*f2(i-3,:)+ &
     		            g(3)*f2(i-2,:)+ &
     		            g(4)*f2(i-1,:)+ &
     		            g(5)*f2(i,:)+ &
     		            g(6)*f2(i+1,:)+ &
     		            g(7)*f2(i+2,:)+ &
     		            g(8)*f2(i+3,:))*dxinv 
		ENDDO
		h2(0:3,:)=0.		
		h2(nx-2:nx,:)=0.		
		ENDIF		

	ELSEIF( dir == '+' )THEN

		IF(nop==2)THEN
		DO i=0,nx-1
		  h2(i,:)=(f2(i+1,:)-f2(i,:))*dxinv	
		ENDDO
		h2(nx,:)=0.
		ENDIF


		IF(nop==4)THEN
		DO i=1,nx-2
		  h2(i,:)=(g(1)*f2(i-1,:)+ &
     		            g(2)*f2(i,:)+ &
     		            g(3)*f2(i+1,:)+ &
     		            g(4)*f2(i+2,:))*dxinv 
		ENDDO
		h2(0,:)=0.
		h2(nx-1:nx,:)=0.
		ENDIF		

		IF(nop==8)THEN
		DO i=3,nx-4
		  h2(i,:)=(g(1)*f2(i-3,:)+ &
     		            g(2)*f2(i-2,:)+ &
     		            g(3)*f2(i-1,:)+ &
     		            g(4)*f2(i,:)+ &
     		            g(5)*f2(i+1,:)+ &
     		            g(6)*f2(i+2,:)+ &
     		            g(7)*f2(i+3,:)+ &
     		            g(8)*f2(i+4,:))*dxinv 
		ENDDO
		h2(0:2,:)=0.
		h2(nx-3:nx,:)=0.
		ENDIF		

	ENDIF

	ELSEIF( comp == 'y' ) THEN

	    IF ( dir == '-' ) THEN

		IF(nop==2)THEN
		DO j=1,ny
		  h2(:,j)=(f2(:,j)-f2(:,j-1))*dyinv	
		ENDDO
		h2(:,0)=0.
		ENDIF		

		IF(nop==4)THEN
		DO j=2,ny-1
		  h2(:,j)=(g(1)*f2(:,j-2)+ &
     		            g(2)*f2(:,j-1)+ &
     		            g(3)*f2(:,j)+ &
     		            g(4)*f2(:,j+1))*dyinv 
		ENDDO
		h2(:,0:1)=0.
		h2(:,ny)=0.
		ENDIF		

		IF(nop==8)THEN
		DO j=4,ny-3
		h2(:,j)=(g(1)*f2(:,j-4)+ &
     		          g(2)*f2(:,j-3)+ &
     		          g(3)*f2(:,j-2)+ &
     		          g(4)*f2(:,j-1)+ &
     		          g(5)*f2(:,j)+ &
     		          g(6)*f2(:,j+1)+ &
     		          g(7)*f2(:,j+2)+ &
     		          g(8)*f2(:,j+3))*dyinv 
		ENDDO
		h2(:,0:3)=0.
		h2(:,ny-2:ny)=0.
		ENDIF		

	ELSEIF( dir == '+' )THEN

		IF(nop==2)THEN
		DO j=0,ny-1
		  h2(:,j)=(f2(:,j+1)-f2(:,j))*dyinv	
		ENDDO
		h2(:,ny)=0.
		ENDIF


		IF(nop==4)THEN
		DO j=1,ny-2
		  h2(:,j)=(g(1)*f2(:,j-1)+ &
     		            g(2)*f2(:,j)+ &
     		            g(3)*f2(:,j+1)+ &
     		            g(4)*f2(:,j+2))*dyinv 
		ENDDO
		h2(:,0)=0.
		h2(:,ny-1:ny)=0.
		ENDIF		

		IF(nop==8)THEN
		DO j=3,ny-4
		  h2(:,j)=(g(1)*f2(:,j-3)+ &
     		            g(2)*f2(:,j-2)+ &
     		            g(3)*f2(:,j-1)+ &
     		            g(4)*f2(:,j)+ &
     		            g(5)*f2(:,j+1)+ &
     		            g(6)*f2(:,j+2)+ &
     		            g(7)*f2(:,j+3)+ &
     		            g(8)*f2(:,j+4))*dyinv 
		ENDDO
		h2(:,0:2)=0.
		h2(:,ny-3:ny)=0.
		ENDIF		

	    ENDIF
   ENDIF

END SUBROUTINE pder2

!#############################################################################
