!*****************************************************************************
!***************** Check & verification of setup parameters ******************
!*****************************************************************************

SUBROUTINE fd3s_check

    IMPLICIT NONE 
    INCLUDE 'common_global.h'
        
    REAL ddx(0:nx),ddy(0:ny),ddz(0:nz) 
    REAL ddxmin,ddxmax,ddymin,ddymax,ddzmin,ddzmax,ddmax
    REAL vmax,vmin,rrmin,sinmin,nopfact

    ij(1,1)=4   ! matrix notation for moment tensor elements
    ij(1,2)=7
    ij(1,3)=8
    ij(2,1)=7
    ij(2,2)=5
    ij(2,3)=9
    ij(3,1)=8
    ij(3,2)=9
    ij(3,3)=6

    WRITE(*,*)' Begin check '


!=============================================================================

! Write misc. setup parameters into log file

        WRITE(99,*)' Begin check '

	WRITE(99,*)' ----------------------------- '
	WRITE(99,*)'        The set up  '
	WRITE(99,*)' ----------------------------- '
	WRITE(99,*)' '
        WRITE(99,*)' '
	WRITE(99,*)' seisfile    :  ',seisfile     
	WRITE(99,*)' '
	WRITE(99,*)' nx  :  ',nx
	WRITE(99,*)' ny  :  ',ny
	WRITE(99,*)' nz  :  ',nz
	WRITE(99,*)' nt               :  ',nt
	WRITE(99,*)' '
	WRITE(99,*)' dt	 :  ',dt
	WRITE(99,*)' dx	 :  ',dx
	WRITE(99,*)' dy	 :  ',dy
	WRITE(99,*)' dz	 :  ',dz
	WRITE(99,*)' '
        WRITE(99,*)' nop :  ',nop
        WRITE(99,*)' Operator weights (one-sided): '

        DO i=1,nop/2
         WRITE(99,*)' g(',i,')=',g(i)
        ENDDO

        WRITE(99,*)''
        WRITE(99,*)'Interpolation & surface:'

        IF(fs_model==1) THEN
          WRITE(99,*)'Free surface after Graves'
        ELSE
          WRITE(99,*)'Free surface by (anti-)symmetry'   
        ENDIF

        IF (elast_inter ==1) THEN
          WRITE(99,*)'Interpolation of Density and Lame Parameters'
        ELSE
          WRITE(99,*)'No elastic interpolation'
        ENDIF
  
        WRITE(99,*)''
        WRITE(99,*)' izfree      :  ',izfree
        WRITE(99,*)' r1(izfree)  :  ',zs(izfree)
	WRITE(99,*)' ' 
	WRITE(99,*)' model_type  :  ',model_type
        WRITE(99,*)' '
        WRITE(99,*)'Homogeneous model parameters:'
	WRITE(99,*)' vs0         :  ',vs0
	WRITE(99,*)' vp0         :  ',vp0
	WRITE(99,*)' rho0        :  ',rho0
        WRITE(99,*)' '
	WRITE(99,*)' ibound( 1 -> free surface at z=0. :',ibound
        WRITE(99,*)'         absorbtion otherwise)'        
	WRITE(99,*)' '
	WRITE(99,*)' Snapshots'
	WRITE(99,*)' iplanex    : ',iplanex
	WRITE(99,*)' iplaney    : ',iplaney
	WRITE(99,*)' iplanez    : ',iplanez
	WRITE(99,*)' '
!      ENDIF


!=============================================================================

! source specific variables

        WRITE(99,*)'Source coordinates (exact):' 
	WRITE(99,*)' xxs [deg]        :  ',xxs
	WRITE(99,*)' yys [deg]        :  ',yys
	WRITE(99,*)' zzs [km]          :  ',zzs/1000.
        WRITE(99,*)''
        WRITE(99,*)' Source indices (x,y,z):',isx,isy,zsrc
        WRITE(99,*)''
        WRITE(99,*)'Discretized source coordinates:' 
	WRITE(99,*)' xsrc_grid [deg]        :  ',xs(isx)*180/pi
	WRITE(99,*)' ysrc_grid [deg]        :  ',ys(isy)*180/pi
	WRITE(99,*)' zsrc_grid [km]          :  ',zs(isz)/1000.
        WRITE(99,*)' '     
	WRITE(99,*)' source_type(1-x,2-y,3-z,4-expl,10-Mij) : ',source_type
	WRITE(99,*)' aa(src period [s], 0.->delta)          :',aa
	WRITE(99,*)' alpha(half width of source gauss [m])  :',alpha
	WRITE(99,*)' it0(time index for delta source)       : ',it0
	WRITE(99,*)' '

	IF(source_type==10)THEN

         WRITE(99,*)' Source Moment Tensor '
	 WRITE(99,*)' dip       : ',dip/pi*180.
	 WRITE(99,*)' rake      : ',rake/pi*180.
	 WRITE(99,*)' strike    : ',strike/pi*180.	
	 WRITE(99,*)' '
               
	 DO i=1,3
	  WRITE(99,9)moment(ij(i,1)),moment(ij(i,2)),moment(ij(i,3))
	 ENDDO

 9 FORMAT(3f10.2)

         ENDIF      ! moment tensor

!=============================================================================

	cc=180./pi
	WRITE(99,*)' Range of Space :'
        WRITE(99,*)MINVAL(xs)*cc,' < x (deg) < ',MAXVAL(xs)*cc
        WRITE(99,*)MINVAL(ys)*cc,' < y (deg) < ',MAXVAL(ys)*cc
        WRITE(99,*)MINVAL(zs)/1000.,' < z ( km ) < ',MAXVAL(zs)/1000.
        WRITE(99,*)' real depth range:',MINVAL(zs)/1000.,' < z (km) <', &
                     zs(izfree)/1000.      
	WRITE(99,*)' '

!=============================================================================

! grid spacing

! calculate minimal and maximal grid spacing

      ddx=ABS(xs-CSHIFT(xs,dim=1,shift=1)) !array of grid spacings along theta 
      ddy=ABS(ys-CSHIFT(ys,dim=1,shift=1)) !array of grid spacings along phi 
      ddz=ABS(zs-CSHIFT(zs,dim=1,shift=1)) !array of grid spacings along r 
      ddxmin=MINVAL(ddx(1:nx-1))           ! min. grid spacing theta (rad)
      ddxmax=MAXVAL(ddx(1:nx-1))           ! max. grid spacing theta (rad)
      ddymin=MINVAL(ddy(1:ny-1))           ! min. grid spacing phi (rad)
      ddymax=MAXVAL(ddy(1:ny-1))           ! max. grid spacing phi (rad)
      ddzmin=MINVAL(ddz(1:nz-1))           ! min. grid spacing r (m)
      ddzmax=MAXVAL(ddz(1:nz-1))           ! max. grid spacing r (m)

! the above extremal values are generally constant, but useful for 
! further considerable grid stretching/irregular grid spacing 

        ddmax=MAXVAL(zs)*MAXVAL(SIN(xs))*ddymax   ! max. grid spacing phi (m)

        IF (MAXVAL(zs)*ddxmax .GT. ddmax) THEN    ! compare to max. grid 
         ddmax=MAXVAL(zs)*ddxmax                  ! spacing theta (m)  
        ENDIF
        IF (ddzmax .GT. ddmax ) THEN              ! compare to max. grid 
         ddmax=ddzmax                             ! spacing r (m) 
        ENDIF                                     ! ddmax: abs. max. grid spac.
                                                
 	rrmin=MINVAL(zs)                          ! lowermost model part
	sinmin=MINVAL(SIN(xs))                    ! most poleward model part 
                                           
	WRITE(99,*)' Range of space increments :'
        WRITE(99,*)MINVAL(zs)*ddxmin,' < dx (m) < ',MAXVAL(zs)*ddxmax
        WRITE(99,*)rrmin*sinmin*ddymin,' < dy (m) < ', &
                   MAXVAL(zs)*MAXVAL(SIN(xs))*ddymax
        WRITE(99,*)ddzmin,' < dz ( m ) < ',ddzmax


        WRITE(*,*)' Max. grid point distance [km] :',ddmax/1000.
        WRITE(*,*)ddxmin*180/pi,' < dtheta [deg] <',ddxmax*180/pi
        WRITE(*,*)ddymin*180/pi,' < dphi [deg]   <',ddymax*180/pi

        WRITE(99,*)''
        WRITE(99,*)' Max. grid point distance [km] :',ddmax/1000.
        WRITE(99,*)ddxmin*180/pi,' < dtheta [deg] <',ddxmax*180/pi
        WRITE(99,*)ddymin*180/pi,' < dphi [deg] <',ddymax*180/pi


!=============================================================================

! stability conditions

        nopfact=0.
        DO i=1,nop/2                        ! abs. sum over operator weights  
         nopfact=nopfact+ABS(g(i))          ! for staibility criterion
        ENDDO

 	vmax=MAXVAL(SQRT((lam+2*mu)*rhoinv))      ! max. P-vel. 
        vmin=MINVAL(SQRT((mu)*rhoinv))            ! min. S-vel.
        
	WRITE(99,*)' '
        WRITE(99,*)'Stability :'
        WRITE(99,*)'General stability factor : ', &
                     vmax*dt*nopfact* & 
                    SQRT(1/rrmin**2/(ddxmin**2+(sinmin*ddymin)**2)+1/ddzmin**2)
	WRITE(99,*)' Stability factor x :  ', &
                    vmax*dt*SQRT(3.)*nopfact/(rrmin*ddxmin)
	WRITE(99,*)' Stability factor y :  ', &
     	            vmax*dt*SQRT(3.)*nopfact/(rrmin*sinmin*ddymin)
	WRITE(99,*)' Stability factor z :  ', &
                    vmax*dt*SQRT(3.)*nopfact/(ddzmin)
        WRITE(99,*)' NOP-factor :',nopfact

	WRITE(99,*)' '
        IF (aa .NE. 0) THEN
          WRITE(99,*)'Min. number of grid points per wavelength: ', &
                   vmin*aa/ddmax
          WRITE(99,*)''
        ELSE
          IF (nop .EQ. 2) THEN
            WRITE(99,*)'Dominant period at 25 pts/wavelength :',25*ddmax/vmin
          ELSEIF(nop .EQ.4)THEN
            WRITE(99,*)'Dominant period at 15 pts/wavelength :',15*ddmax/vmin
          ELSEIF(nop .EQ. 8) THEN
            WRITE(99,*)'Dominant period at 10 pts/wavelength :',10*ddmax/vmin
          ENDIF         
        ENDIF

!=============================================================================

! write onto console

        WRITE(*,*)' '
        WRITE(*,*)'Stability'
        WRITE(*,*)'General stability factor : ', &
                    vmax*dt*nopfact* &
                    SQRT(1/rrmin**2/(ddxmin**2+(sinmin*ddymin)**2)+1/ddzmin**2)
        WRITE(*,*)' Stability factor x :', &
                    vmax*dt*SQRT(3.)*nopfact/(rrmin*ddxmin)
	WRITE(*,*)' Stability factor y :  ', &
     	            vmax*dt*SQRT(3.)*nopfact/(rrmin*sinmin*ddymin)
	WRITE(*,*)' Stability factor z :  ', &
                    vmax*dt*SQRT(3.)*nopfact/(ddzmin)
        WRITE(*,*)' NOP-factor :',nopfact

	WRITE(*,*)' '

        IF (aa .NE. 0) THEN
          WRITE(*,*)'Min. number of grid points per wavelength: ', &
                   vmin*aa/ddmax
          WRITE(*,*)''
        ELSE

          IF (nop .EQ. 2) THEN  
            WRITE(*,*)'Dominant period at 25 pts/wavelength :',25*ddmax/vmin
          ELSEIF(nop .EQ.4)THEN
            WRITE(*,*)'Dominant period at 15 pts/wavelength :',15*ddmax/vmin
          ELSEIF(nop .EQ. 8) THEN
            WRITE(*,*)'Dominant period at 10 pts/wavelength :',10*ddmax/vmin
          ENDIF
          WRITE(*,*)''
         ENDIF
      


!=============================================================================

! more parameters, just saved by surface node

	WRITE(99,*)' '
	WRITE(99,*)' isamp(sampling in time)          : ',isamp
	WRITE(99,*)' ssamp(snapshot sampling)         : ',ssamp
	WRITE(99,*)' iflush(seis output interval)     : ',iflush
	WRITE(99,*)' '
	WRITE(99,*)' icheck(Output of max/min values) : ',icheck
	WRITE(99,*)' '
	WRITE(99,*)' Physical dimensions '
	WRITE(99,*)' xmax [rad]       : ',xmax
	WRITE(99,*)' xmin [rad]       : ',xmin
	WRITE(99,*)' ymax [rad]       : ',ymax
	WRITE(99,*)' ymin [rad]       : ',ymin
	WRITE(99,*)' zmax [m]         : ',zmax
	WRITE(99,*)' zmin [m]         : ',zmin

!=============================================================================

! model space and elastic properties of all nodes 

	WRITE(99,*)' '
	WRITE(99,*)' '
	WRITE(99,*)' Model'
	WRITE(99,*)' ------'
	WRITE(99,*)' '
	WRITE(99,*)MINVAL(lam),' < lam < ',MAXVAL(lam)
	WRITE(99,*)MINVAL(mu),' < mu < ',MAXVAL(mu)
	WRITE(99,*)MINVAL(1/rhoinv),' < rho < ',MAXVAL(1/rhoinv)      
	WRITE(99,*)MINVAL(zs),' < r1 < ',MAXVAL(zs)
	WRITE(99,*)MINVAL(zs-dz/2),' < r2 < ',MAXVAL(zs-dz/2)
	WRITE(99,*)MINVAL(xs*cc),' < theta1 < ',MAXVAL(xs*cc)
	WRITE(99,*)MINVAL((xs+dx/2)*cc),' < theta2 < ',MAXVAL((xs+dx/2)*cc)
        WRITE(99,*)MINVAL(SQRT((lam+2*mu)*rhoinv)),' < vp < ' &
                  ,MAXVAL(SQRT((lam+2*mu)*rhoinv))
	WRITE(99,*)MINVAL(SQRT(mu*rhoinv)),' < vs < ',MAXVAL(SQRT(mu*rhoinv))
	WRITE(99,*)' ' 

	WRITE(99,*)' '
	WRITE(99,*)' Receiver Locations (theta,phi) '
	WRITE(99,*)' '

	DO i=1,nr	
	 WRITE(99,*)i,recloc(1,i),recloc(2,i)
	ENDDO

        CALL logfile(vmax,nopfact)  ! write logfile to be loaded in matlab

        WRITE(99,*)' '
        WRITE(99,*)'Approx. needed disk space:',&
                   (nx*ny*nz*4*(9*nt+2+1/REAL(nx))+&
                   nt*(8+3*REAL(nr)/REAL(isamp)))/(1024*1024*ssamp),' MB'
      
        WRITE(*,*)'Approx. needed disk space:',&
                   (nx*ny*nz*4*(9*nt+2+1/REAL(nx))+&
                   nt*(8+3*REAL(nr)/REAL(isamp)))/(1024*1024*ssamp),' MB'

	WRITE(99,*)' '
	WRITE(99,*)' '
	WRITE(99,*)' '
	WRITE(99,*)' Starting time loop for ...',nt,' time steps ... '      
	WRITE(99,*)' '
	WRITE(99,*)' '
        
	WRITE(*,*)' '
	WRITE(*,*)' Starting time loop for ...',nt,' time steps ... '      
	WRITE(*,*)' '
	
	RETURN

END SUBROUTINE fd3s_check


!########### Additional subroutines ########################################## 

! subroutine to save setup parameters in a way which can be loaded by matlab

SUBROUTINE logfile(maxvel,operfact)

    IMPLICIT NONE
    INCLUDE 'common_global.h'
    INTEGER lnblnk
    REAL maxvel,operfact

  OPEN(unit=96,file=seisfile(1:lnblnk(seisfile))//'_PAR',status='unknown')
    WRITE(96,*)'file=    ',seisfile
    WRITE(96,*)'nx=      ',nx
    WRITE(96,*)'ny=      ',ny
    WRITE(96,*)'nz=      ',nz
    WRITE(96,*)'nop=     ',nop
    WRITE(96,*)'izfree=  ',izfree
    WRITE(96,*)'nt=      ',nt
    WRITE(96,*)'dt=      ',dt
    WRITE(96,*)'model=   ',model_type
    WRITE(96,*)'dx=      ',dx
    WRITE(96,*)'dy=      ',dy
    WRITE(96,*)'dz=      ',dz
    WRITE(96,*)'T=       ',aa
    WRITE(96,*)'xxs=     ',xxs
    WRITE(96,*)'yys=     ',yys
    WRITE(96,*)'zzs=     ',zzs
    WRITE(96,*)'isx=     ',isx
    WRITE(96,*)'isy=     ',isy
    WRITE(96,*)'zsrc=    ',zsrc
    WRITE(96,*)'it0=     ',it0
    WRITE(96,*)'ssamp=   ',ssamp
    WRITE(96,*)'isamp=   ',isamp
    WRITE(96,*)'xmax=    ',xmax
    WRITE(96,*)'xmin=    ',xmin
    WRITE(96,*)'ymax=    ',ymax
    WRITE(96,*)'ymin=    ',ymin
    WRITE(96,*)'zmax=    ',zmax
    WRITE(96,*)'zmin=    ',zmin
    WRITE(96,*)'nr=      ',nr
    WRITE(96,*)'recfile= ',recfile
    WRITE(96,*)'nopfact= ',operfact
    WRITE(96,*)'vmax=    ',maxvel
  CLOSE(96)

END SUBROUTINE logfile

!#############################################################################










