
!*****************************************************************************
!***************** Declaration of all global variables ***********************
!*****************************************************************************

! Predefined parameters

    INTEGER nx,ny,nz        ! number of grid points per dimension  
    INTEGER maxnt,maxnr     ! max. amount of time steps, receivers
    INTEGER np,maxnop       ! number of nodes, max. operator length
    REAL pi
    INCLUDE 'params.h'      ! nx,ny,nz,maxnt,maxnr,maxnop

!==============================================================================

! File Names
 
    CHARACTER*50 recfile,seisfile,outfile

!==============================================================================

! Miscellaneous Variables

    INTEGER i,j,k,ix,iy,iz   ! index variables
    INTEGER icheck,isamp     ! output increments (see Par)
    INTEGER nop              ! FD operator length
    REAL g(maxnop)           ! FD operator weights


!==============================================================================
 
! Time parameters
 
    INTEGER it,nt            ! time index, number of time steps
    REAL dt                  ! time increment 

!==============================================================================

! Source Variables 
    
    REAL, DIMENSION(0:nx,0:ny,0:nz) :: gauss   ! spatial source distribution
    REAL dip,rake,strike,srcperiod,alpha,aa    ! see Par
    INTEGER isx,isy,isz,zsrc                   ! indices for source location
    INTEGER ij(3,3),srcproc,source_type,it0    ! node of source location

    REAL so(2*maxnt),smax    ! source time function, max ampl. (norm.)
    REAL moment(4:9)         ! moment tensor elements
    REAL xxs,yys,zzs         ! source coord. (see Par)
    REAL zzzs                ! source radius

!==============================================================================

! Geometrical variables

    REAL, DIMENSION(0:nx,0:ny,0:nz) :: sininv1,sininv2,cottheta1,cottheta2

    REAL xs(0:nx),ys(0:ny),zs(0:nz)     ! coordinates (rad,rad,m)
    REAL dx,dy,dz,dxinv,dyinv,dzinv     ! (inverse) grid spacing 
    REAL cc,ccinv                       ! conversion factors rad-deg 
    REAL xmin,xmax,ymin,ymax,zmin,zmax  ! (see Par)
    REAL xrange,yrange,zrange           ! model space range

!==============================================================================

! Free Surface Variables

    INTEGER izfree,fs_model             ! (see Par)

! Graves surface implementation 
    
    REAL xi(0:nx,0:ny),eta(0:nx,0:ny)   ! elastic-geometrical constants
    REAL alph,beta,gamma,delta          ! geometrical constants

!==============================================================================

! Absorbing boundaries

    REAL, DIMENSION(0:nx,0:ny,0:nz) :: window  ! 3D tapering grid  
    REAL taper(1:nx)                           ! Gaussian damping function
    INTEGER ibound,nabs                        ! (see Par)

!==============================================================================

! Elastic Parameters & Model variables

    REAL, DIMENSION(0:nx,0:ny,0:nz) :: rhoinv,mu,lam  ! 3D elastic parameters
    REAL ro(0:nz),vp(0:nz),vs(0:nz),vs0,vp0,rho0      ! radially symm. vel.
    INTEGER savemodel,model_type,elast_inter          ! (see Par)

!==============================================================================

! Velocity & Stress fields

    REAL,DIMENSION(0:nx,0:ny,0:nz)::w11,w12,w13 ! vel.comp. theta(t), phi(p), r
    REAL,DIMENSION(0:nx,0:ny,0:nz)::w14,w15,w16 ! norm.stress(t,t),(p,p),(r,r)
    REAL,DIMENSION(0:nx,0:ny,0:nz)::w17,w18,w19 ! shear stress(t,p),(t,r),(p,r)
    REAL,DIMENSION(0:nx,0:ny,0:nz)::w21,w22,w23 ! acceleration theta,phi,r

    REAL rotsurf(0:nx,0:ny),divsurf(0:nx,0:ny)  ! curl & divergence, surface 
    REAL rotx(0:ny,0:nz),divx(0:ny,0:nz)        ! curl & divergence, t=const 
    REAL roty(0:nx,0:nz),divy(0:nx,0:nz)        ! curl & divergence, p=const

!==============================================================================

! Receivers 
       
    INTEGER iflush,rotdiv        ! (see Par)
    INTEGER nr                   ! number of receivers (first line of recfile)
    REAL recloc(1:2,1:maxnr)     ! receiver location theta(deg),phi(deg) 

! Receiver interpolation variables, see fd3s_init.f90

    INTEGER ilowx(maxnr),iupx(maxnr),jlowx(maxnr),jupx(maxnr)
    INTEGER ilowy(maxnr),iupy(maxnr),jlowy(maxnr),jupy(maxnr)
    INTEGER ilowz(maxnr),iupz(maxnr),jlowz(maxnr),jupz(maxnr)   
    REAL xqotx(maxnr),xqotminx(maxnr),yqotx(maxnr),yqotminx(maxnr)
    REAL xqoty(maxnr),xqotminy(maxnr),yqoty(maxnr),yqotminy(maxnr)
    REAL xqotz(maxnr),xqotminz(maxnr),yqotz(maxnr),yqotminz(maxnr) 
 
!==============================================================================

! Snapshots

    INTEGER ssamp,iplanex,iplaney,iplanez ! (see Par)

!==============================================================================


! Common blocks 

! Real variables        
COMMON /creal/ dx,dy,dz,dxinv,dyinv,dzinv, &  ! grid spacing
xmin,xmax,ymin,ymax,zmin,zmax,xs,ys,zs, &     ! geometrical parameters
sininv1,sininv2,cottheta1,cottheta2, &             
cc,ccinv,xrange,yrange,zrange, &               
dt,g, &                                       ! misc. values 
xxs,yys,zzs,zzzs,dip,rake,strike,srcperiod, & ! source variables
alpha,gauss,smax,so,aa,moment, &                   
taper,window, &                               ! boundary variables
rhoinv,mu,lam,vs0,vp0,rho0,vp,vs,ro, &        ! elastic parameters 
w11,w12,w13,w21,w22,w23, &                    ! vel. & accel. fields
w14,w15,w16,w17,w18,w19, &                    ! stress fields
rotsurf,divsurf,rotx,roty,divx,divy, &        ! curl & divergence
xqotx,xqotminx,yqotx,yqotminx, &              ! receiver interpolation
xqoty,xqotminy,yqoty,yqotminy, &
xqotz,xqotminz,yqotz,yqotminz,recloc, & 
xi,eta,alph,beta,gamma,delta                  ! Graves free surface parameters

!==============================================================================

! Integer variables
COMMON /cint/ it,nt,it0,icheck,isamp, &       ! temporal values
model_type,ibound,nabs,izfree,nop,&           ! misc. model variables
ij,srcproc,source_type, &                     ! source variables
isx,isy,isz,zsrc, &
iflush,nr, &                                  ! receivers 
ilowx,iupx,jlowx,jupx,ilowy,iupy, &           ! receiver interpolation
jlowy,jupy,ilowz,iupz,jlowz,jupz, &
ssamp,iplanex,iplaney,iplanez, &              ! snapshots
rotdiv,fs_model,elast_inter,savemodel         ! misc. switches

!==============================================================================

! Character variables
COMMON /cchar/ seisfile,recfile,outfile 

