% GEOSENSOR Project, HI 03-01-2004
%
%
% rot_plot_basic
% Program to visualize seismograms and rotation data

clear
close all

cd ../NewDataBase               % cd to DataBase
list_of_events                  % Get list of available events


for ie=1:ne,                     % Loop over events

    disp(sprintf(' Processing event %i : %s ',ie,deblank(events(ie,:))));
    eval(['load ' deblank(events(ie,:)) ]);
    
    
% Converting translations to m/s, rename
TEdata = translation_E;
TNdata = translation_N;
TZdata = translation_Z;
Transverse_accel = Transverse_accel;
Ttime = translation_time;

% Rename Rotations
RZdata = rotation_Z; 
Rtime = rotation_time;

% Rename Trans
Tdata=Transverse_accel;
Tdata(length(Tdata)+1)=0;

% Get length of tiem window and sampling rate
dts=(Ttime(2)-Ttime(1));
nts=length(Ttime);
dtr=(Rtime(2)-Rtime(1));
ntr=length(Rtime);

% Resample rotation rate to the same as trnalsations
iRZdata=interp1(Rtime,RZdata,Ttime);
% Getting rid of NaNs
iRZdata(find(isnan(iRZdata)==1))=(1:length(find(isnan(iRZdata)==1)))*0;


% Low pass Filtering
Tmin=20;     % cutoff period (s)

% Filtering
disp(' Filtering ... ')
TNdata=lowpass(TNdata,dts,1/Tmin,1);
TEdata=lowpass(TEdata,dts,1/Tmin,1);
Tdata=lowpass(Tdata,dts,1/Tmin,1);
iRZdata=lowpass(iRZdata,dts,1/Tmin,1);


% estimate phase velocity from max values
c=max(Tdata)/max(iRZdata);


% Walk through backazimuth angles and calculate xcorr
aTEdata=diff(TEdata)/dts;
aTNdata=diff(TNdata)/dts;

tmin=event_windows(ie,1);itmin=round(tmin/dts);
tmax=event_windows(ie,2);itmax=round(tmax/dts);
Ttime=Ttime(itmin:itmax);
aTEdata=aTEdata(itmin:itmax);
aTNdata=aTNdata(itmin:itmax);
iRZdata=iRZdata(itmin:itmax);

% Processing

d=40; % = 10;% length of time window (s)
id=round(d/dts);
id2=round(id/2);

i=id2;
ii=1;
iang=0;

disp(' Calculating crosscorrelation ');

ainc=5;
x=zeros([round(180/ainc),round(length(Ttime)/id2)]);

    for k=1:ainc:180,
       
        iang=iang+1; 
        ang(iang)=k/180*pi;
        Tdata=-aTEdata*cos(ang(iang))+aTNdata*sin(ang(iang));
        disp(sprintf(' Sampling angle %i deg ',k))
        i=id2;
        ii=1;
        while i < itmax-itmin-id2,
            ia=i-id2+1;iz=i+id2; 
            if iz<itmax-itmin-id2,
                t(ii)=Ttime(i);
                f=xcorr(Tdata(ia:iz),iRZdata(ia:iz),'coeff');
                %x(iang,ii)=f(id);
                x(iang,ii)=max(abs(f));
                % x(iang,ii)=max(xcorr(Tdata(ia:ie),iRZdata(ia:ie),'coeff'));
                ii=ii+1;
            end
            i=i+id2;
        end    
    end

    % Plotting
    
    colormap gray
    map=colormap;
    for i=1:length(map),cmap(i,:)=map(length(map)+1-i,:);end

    pow=2;

    c0=max(Tdata)/max(iRZdata);
    thres=0.95;
    subplot(211),plot(Ttime,aTEdata/c0,'k-',Ttime,iRZdata+max(iRZdata),'r-'),axis([tmin tmax -Inf Inf])
    title(sprintf(' Event %i : %s - #%s - T_{min}=%i s',ie,deblank(events(ie,:)),header(2,11:18),Tmin))
    xlabel(' Time (s)')
    ylabel(' Rot.rate (deg/s) ')
    subplot(212),imagesc(t,ang/pi*180,x.^pow),hold on
    axis([tmin tmax -Inf Inf])
    colormap(cmap)
    [rmax,I] = max(x);
    for i=1:length(rmax),
     if rmax(i)> thres, 
     subplot(212),plot(t(i),ang(I(i))/pi*180,'k+')
 end
end
hold off 
xlabel(' Time (s)')
ylabel(' Propagation direction (deg) ')
   
% Plot to eps file
pfile=sprintf('../Figures/eps/%s_filt_%i_backaz.eps',deblank(events(ie,:)),Tmin);
disp(sprintf(' Writing plot to file %s',pfile));
eval([' print -depsc2 ' pfile ]);
pfile=sprintf('../Figures/jpg/%s_filt_%i_backaz.jpg',deblank(events(ie,:)),Tmin);
disp(sprintf(' Writing plot to file %s',pfile));
eval([' print -djpeg100 ' pfile ]);

end