% GEOSENSOR Project, HI 03-01-2004
%
%
% rot_plot_basic
% Program to visualize seismograms and rotation data

clear
close all

cd ../NewDataBase               % cd to DataBase
list_of_events                  % Get list of available events


for ie=1:ne,                     % Loop over events

    disp(sprintf(' Processing event %i : %s ',ie,deblank(events(ie,:))));
    eval(['load ' deblank(events(ie,:)) ]);
    
    
% Converting translations to m/s, rename
TEdata = translation_E;
TNdata = translation_N;
TZdata = translation_Z;
Transverse_accel = Transverse_accel;
Ttime = translation_time;

% Rename Rotations
RZdata = rotation_Z; 
Rtime = rotation_time;

% Rename Trans
Tdata=Transverse_accel;
Tdata(length(Tdata)+1)=0;

% Get length of tiem window and sampling rate
dts=(Ttime(2)-Ttime(1));
nts=length(Ttime);
dtr=(Rtime(2)-Rtime(1));
ntr=length(Rtime);

% Resample rotation rate to the same as trnalsations
iRZdata=interp1(Rtime,RZdata,Ttime);
% Getting rid of NaNs
iRZdata(find(isnan(iRZdata)==1))=(1:length(find(isnan(iRZdata)==1)))*0;


% Low pass Filtering
Tmin=10;     % cutoff period (s)

% Filtering
disp(' Filtering ... ')
TZdata=lowpass(TZdata,dts,1/Tmin,1);
TNdata=lowpass(TNdata,dts,1/Tmin,1);
TEdata=lowpass(TEdata,dts,1/Tmin,1);
Tdata=lowpass(Tdata,dts,1/Tmin,1);
iRZdata=lowpass(iRZdata,dts,1/Tmin,1);


% estimate phase velocity from max values
c=max(Tdata)/max(iRZdata);

% Plotting

subplot(511)
plot(Ttime,TZdata),axis([0 max(Ttime) -max(abs(TZdata)) max(abs(TZdata)) ])
ylabel(' Z-Vel (m/s) ')
title(sprintf(' Event %i : %s - #%s - T_{min}=%i s',ie,deblank(events(ie,:)),header(2,11:18),Tmin))
subplot(412)
plot(Ttime,TNdata),axis([0 max(Ttime) -max(abs(TNdata)) max(abs(TNdata)) ])
ylabel(' N-Vel (m/s) ')
subplot(413)
plot(Ttime,TEdata),axis([0 max(Ttime) -max(abs(TEdata)) max(abs(TEdata)) ])
ylabel(' E-Vel (m/s) ')
subplot(414)
plot(Ttime,Tdata/c,'k-',Ttime,iRZdata,'r-'),axis([0 max(Ttime) -max(abs(iRZdata)) max(abs(iRZdata)) ])
xlabel(' Time (s) ')
ylabel(' Rot. Rate (deg/s) ')
drawnow

% Plot to eps file
pfile=sprintf('../Figures/eps/%s_filt_%i.eps',deblank(events(ie,:)),Tmin);
disp(sprintf(' Writing plot to file %s',pfile));
eval([' print -depsc2 ' pfile ]);
pfile=sprintf('../Figures/jpg/%s_filt_%i.jpg',deblank(events(ie,:)),Tmin);
disp(sprintf(' Writing plot to file %s',pfile));
eval([' print -djpeg100 ' pfile ]);

end