
clear

% new processing tool that aims at
% 1) estimating propagation direction of horizontally polarized waves
% 2) phase  velocity of those waves if they exist
% from collocated measurements of translations and rotations

disp(' Loading data ... ')
load ../Hokkaido/NewNew/Hokkaido_V1.3.mat

%   RZdata             21213x1                   169704  double array
%   Rtime              21213x1                   169704  double array
%   TEdata            108000x1                   864000  double array
%   TNdata            108000x1                   864000  double array
%   TZdata            108000x1                   864000  double array
%   Transverse_accel  107999x1                   863992  double array
%   Ttime             108000x1                   864000  double array
%   ans                    1x1                        8  double array
%   dt                     1x1                        8  double array

TEdata = translation_E/100;
TNdata = translation_N/100;
TZdata = translation_Z/100;
Transverse_accel = Transverse_accel/100;
Ttime = translation_time;
Ttime=Ttime(1:length(Ttime)-1)*3600;

RZdata = rotation_Z; 
Rtime = rotation_time*3600;;

dts=(Ttime(2)-Ttime(1));
nts=length(Ttime);
dtr=(Rtime(2)-Rtime(1));
ntr=length(Rtime);
iRZdata=interp1(Rtime,RZdata,Ttime);

aTEdata=diff(TEdata)/dts;
aTNdata=diff(TNdata)/dts;
c0=5000;
 
% Quantify semblance between data
tmin=dts;itmin=round(tmin/dts);
tmax=14000;itmax=round(tmax/dts);

Ttime=Ttime(itmin:itmax);
aTEdata=aTEdata(itmin:itmax);
aTNdata=aTNdata(itmin:itmax);
iRZdata=interp1(Rtime,RZdata,Ttime);

d=30; % = 10;% length of time window (s)
id=round(d/dts);
id2=round(id/2);

i=id2;
ii=1;
iang=0;

% flow=input(' Give band pass lower corner period (s) : ');flow=1/flow;
% fup=input(' Give band pass upper corner period (s) : ');fup=1/fup;
% aTEdata=bandpass(aTEdata,dts,flow,fup,2);
% aTNdata=bandpass(aTNdata,dts,flow,fup,2);
% iRZdata=bandpass(iRZdata,dts,flow,fup,2);

disp(' Calculating crosscorrelation ');

ainc=2;
x=zeros([round(180/ainc),round(length(Ttime)/id2)]);

    for k=1:ainc:180,
       
        iang=iang+1; 
        ang(iang)=k/180*pi;
        Tdata=-aTEdata*cos(ang(iang))+aTNdata*sin(ang(iang));
        disp(sprintf(' Sampling angle %i deg ',k))
        i=id2;
        ii=1;
        while i < itmax-id2,
            ia=i-id2+1;ie=i+id2; 
            if ie<itmax-id2,
                t(ii)=Ttime(i);
                f=xcorr(Tdata(ia:ie),iRZdata(ia:ie),'coeff');
                %x(iang,ii)=f(id);
                x(iang,ii)=max(f);
                % x(iang,ii)=max(xcorr(Tdata(ia:ie),iRZdata(ia:ie),'coeff'));
                ii=ii+1;
            end
            i=i+id2;
        end    
    end
    

 % plot results
 
 save proc_results Ttime aTEdata c0 iRZdata t ang x
 
 testplot
 
 