% GEOSENSOR Project, HI 03-01-2004
%
%
% rot_plot_basic
% Program to visualize seismograms and rotation data

clear
close all

cd ../NewDataBase               % cd to DataBase
list_of_events                  % Get list of available events


for ie=1:ne,                     % Loop over events

    disp(sprintf(' Processing event %i : %s ',ie,deblank(events(ie,:))));
    eval(['load ' deblank(events(ie,:)) ]);
    
    
% Converting translations to m/s, rename
Transverse_accel = Transverse_accel;
Ttime = translation_time;

% Rename Rotations
RZdata = rotation_Z; 
Rtime = rotation_time;

% Rename Trans
Tdata=Transverse_accel;
Tdata(length(Tdata)+1)=0;

% Get length of tiem window and sampling rate
dts=(Ttime(2)-Ttime(1));
nts=length(Ttime);
dtr=(Rtime(2)-Rtime(1));
ntr=length(Rtime);

% Resample rotation rate to the same as trnalsations
iRZdata=interp1(Rtime,RZdata,Ttime);
% Getting rid of NaNs
iRZdata(find(isnan(iRZdata)==1))=(1:length(find(isnan(iRZdata)==1)))*0;



% Extracting window
tmin=event_windows(ie,1)-1000;
itmin=round(tmin/dts); if itmin<0,itmin=1;end
tmax=event_windows(ie,2)+1000;itmax=round(tmax/dts);if itmax>nts, itmax=nts;end
Ttime=Ttime(itmin:itmax);
Tdata=Tdata(itmin:itmax);Tdata=taper(Tdata,-1000);Tdata=taper(Tdata,1000);
iRZdata=iRZdata(itmin:itmax);iRZdata=taper(iRZdata,-1000);iRZdata=taper(iRZdata,1000);

% Plotting
ii=1;
dT=10;
eps=2;

c=max(Tdata)/max(iRZdata);
plot(Ttime,dT*(Tdata/c)/max((Tdata/c)),'k-',Ttime,dT*iRZdata/max(iRZdata),'r-'),axis([tmin tmax -Inf Inf]),
text(tmin+100,0+eps,' Broadband seismogram ')
hold on

pause

for T=10:dT:100,

    
    disp(sprintf(' Upper period : %g s ',T))
    flow=.85*1/T;
    fup=1.15*1/T;

fTdata=bandpass(Tdata,dts,flow,fup,1);
fiRZdata=bandpass(iRZdata,dts,flow,fup,1);

c=max(fTdata)/max(fiRZdata);
cc(ii)=c/2;
TT(ii)=T;

plot(Ttime,dT*(fTdata/c)/max((fTdata/c))+T,'k-',Ttime,dT*fiRZdata/max(fiRZdata)+T,'r-'),axis([tmin tmax -Inf Inf]),
text(tmin+100,T+eps,sprintf(' c_{phase}=%g m/s ',c/2));

hold on
drawnow

xlabel(' Time (s) ')

ii=ii+1;

end

title(sprintf(' Event %i : %s - #%s ',ie,deblank(events(ie,:)),header(2,11:18)))



% Plot to eps file
pfile=sprintf('../Figures/eps/%s_freq.eps',deblank(events(ie,:)));
disp(sprintf(' Writing plot to file %s',pfile));
eval([' print -depsc2 ' pfile ]);
pfile=sprintf('../Figures/jpg/%s_freq.jpg',deblank(events(ie,:)));
disp(sprintf(' Writing plot to file %s',pfile));
eval([' print -djpeg100 ' pfile ]);

close all

end