
clear
clf

% new processing tool that aims at
% 1) estimating propagation direction of horizontally polarized waves
% 2) phase  velocity of those waves if they exist
% from collocated measurements of translations and rotations

disp(' Loading data ... ')
load ../Hokkaido/NewNew/Hokkaido_V1.3.mat
load ../Hokkaido/NewNewNew/Hokkaido_rest.mat


%   RZdata             21213x1                   169704  double array
%   Rtime              21213x1                   169704  double array
%   TEdata            108000x1                   864000  double array
%   TNdata            108000x1                   864000  double array
%   TZdata            108000x1                   864000  double array
%   Transverse_accel  107999x1                   863992  double array
%   Ttime             108000x1                   864000  double array
%   ans                    1x1                        8  double array
%   dt                     1x1                        8  double array


Ttime = nTime;
Tdata=nTdata;

RZdata = rotation_Z; 
Rtime = rotation_time*3600;;

dts=(Ttime(2)-Ttime(1));
nts=length(Ttime);
dtr=(Rtime(2)-Rtime(1));
ntr=length(Rtime);
iRZdata=interp1(Rtime,RZdata,Ttime);

c0=5000;
 
nts=length(Ttime);
iRZdata=interp1(Rtime,RZdata,Ttime);

d=30; % = 10;% length of time window (s)
id=round(d/dts);
id2=round(id/2);

i=id2;
ii=1;
iang=0;


t1=3500;
t2=6500;

Tdata=taper(Tdata,-1000);Tdata=taper(Tdata,1000);
iRZdata=taper(iRZdata',-1000);iRZdata=taper(iRZdata,1000);

ii=0;
dT=10;
eps=2;

c=max(Tdata)/max(iRZdata);
plot(Ttime,dT*(Tdata/c)/max((Tdata/c)),'k-',Ttime,dT*iRZdata/max(iRZdata),'r-'),axis([t1 t2 -Inf Inf]),
text(t1+100,0+eps,' Broadband seismogram ')
hold on

pause

for T=10:dT:200,

    
    disp(sprintf(' Upper period : %g s ',T))
    flow=.9*1/T;
    fup=1.1*1/T;

%flow=1/flow;
%fup=1/fup;
fTdata=bandpass(Tdata,dts,flow,fup,1);
fiRZdata=bandpass(iRZdata,dts,flow,fup,1);

c=max(fTdata)/max(fiRZdata);

%plot(Ttime,Tdata/c,'k-',Ttime,iRZdata,'r-'),axis([t1 t2 -Inf Inf])
plot(Ttime,dT*(fTdata/c)/max((fTdata/c))+T,'k-',Ttime,dT*fiRZdata/max(fiRZdata)+T,'r-'),axis([t1 t2 -Inf Inf]),
text(t1+100,T+eps,sprintf(' c_{phase}=%g m/s ',c/2));

hold on
drawnow

xlabel(' Time (s) ')

ii=ii+1;

%plot(Ttime,aTEdata,'k-'),
%title(sprintf(' T_{dom} = %g s; c_{phase} = %g m/s',T,c/2)),drawnow

end

title(' Rotation (red) - Translation (black) ')
hold off


