% GEOSENSOR Project, HI 03-01-2004
%
%
% rot_plot_basic
% Program to visualize seismograms and rotation data
% Calculating crosscorrelation and phase velocity as a function of time

clear
close all

cd ../NewDataBase_rest              % cd to DataBase
list_of_events                  % Get list of available events


for ie=1:ne,                     % Loop over events

    close all
    disp(sprintf(' Processing event %i : %s ',ie,deblank(events(ie,:))));
    eval(['load ' deblank(events(ie,:)) ]);
    
    
% Converting translations to m/s, rename
Transverse_accel = Transverse_accel;
Ttime = translation_time;

% Rename Rotations
RZdata = rotation_Z; 
Rtime = rotation_time;

% Rename Trans
Tdata=Transverse_accel;
Tdata(length(Tdata)+1)=0;

% Get length of tiem window and sampling rate
dts=(Ttime(2)-Ttime(1));
nts=length(Ttime);
dtr=(Rtime(2)-Rtime(1));
ntr=length(Rtime);

% Resample rotation rate to the same as trnalsations
iRZdata=interp1(Rtime,RZdata,Ttime);
% Getting rid of NaNs
iRZdata(find(isnan(iRZdata)==1))=(1:length(find(isnan(iRZdata)==1)))*0;


% Low pass Filtering
Tmin=10;     % cutoff period (s)

% Filtering
disp(' Filtering ... ')
Tdata=lowpass(Tdata,dts,1/Tmin,1);
iRZdata=lowpass(iRZdata,dts,1/Tmin,1);


% Quantify semblance between data
d=30;               % length of time window (s)
id=round(d/dts);
id2=round(id/2);
thres=.8; %.9
c0=max(Tdata)/max(iRZdata);
dc=5000;

i=id2;
ii=1;
iii=1;

disp(' Calculating semblance ');

cc=[];
tc=[];

while i < nts,
    
    ia=i-id2+1;iz=i+id2; 
    if iz<nts,
    t(ii)=Ttime(i);
    x(ii)=max(xcorr(Tdata(ia:iz),iRZdata(ia:iz),'coeff'));
    
    
    % find appropriate phase velocity
    
    if x(ii) > thres,
        
        iii=iii+1;
        
        k=0;
        for c=1000:5:15000,     
        k=k+1;
        alpha(k)=1/(2*c*1);
        mis=iRZdata(ia:iz)-alpha(k)*Tdata(ia:iz);
        eps(k)=sum(mis'*mis);
        end
        [c,ki]=min(eps); 
        nalpha=alpha(ki);
        tc(iii)=Ttime(i);
        cc(iii)=abs(1/(2*nalpha));
        
    end
    ii=ii+1;
    
    end
    i=i+id;
end


rmax=max(iRZdata);

subplot(311),plot(Ttime,Tdata/c0,'k-',Ttime,rmax+iRZdata,'r-')
title(sprintf(' Event %i : %s - #%s - T_{min}=%i s',ie,deblank(events(ie,:)),header(2,11:18),Tmin))
xlabel(' Time (s)')
ylabel(' Rot. rate (rad/s) '), axis([0, Ttime(end), -inf, inf])
legend('WET','G')
subplot(312),plot(t,abs(x)), axis([0, Ttime(end), -inf, inf])
xlabel(' Time (s)')
ylabel(' Max Cross-corr. norm. ')
subplot(313),plot(tc,cc,'+'), axis([0, Ttime(end), -inf, inf]), hold on
xlabel(' Time (s)')
ylabel(' Est. Phase Vel. (m/s) ')
drawnow

% Plot to eps file
pfile=sprintf('../Figures/eps/%s_filt_xcorr_%i.eps',deblank(events(ie,:)),Tmin);
disp(sprintf(' Writing plot to file %s',pfile));
eval([' print -depsc2 ' pfile ]);
pfile=sprintf('../Figures/jpg/%s_filt_xcorr_%i.jpg',deblank(events(ie,:)),Tmin);
disp(sprintf(' Writing plot to file %s',pfile));
eval([' print -djpeg100 ' pfile ]);

end