
clear
clf

% new processing tool that aims at
% 1) estimating propagation direction of horizontally polarized waves
% 2) phase  velocity of those waves if they exist
% from collocated measurements of translations and rotations

disp(' Loading data ... ')
load ../Hokkaido/NewNew/Hokkaido_V1.3.mat

%   RZdata             21213x1                   169704  double array
%   Rtime              21213x1                   169704  double array
%   TEdata            108000x1                   864000  double array
%   TNdata            108000x1                   864000  double array
%   TZdata            108000x1                   864000  double array
%   Transverse_accel  107999x1                   863992  double array
%   Ttime             108000x1                   864000  double array
%   ans                    1x1                        8  double array
%   dt                     1x1                        8  double array

TEdata = translation_E/100;
TNdata = translation_N/100;
TZdata = translation_Z/100;
Transverse_accel = Transverse_accel/100;
Ttime = translation_time;
Ttime=Ttime(1:length(Ttime)-1)*3600;

RZdata = rotation_Z; 
Rtime = rotation_time*3600;;

dts=(Ttime(2)-Ttime(1));
nts=length(Ttime);
dtr=(Rtime(2)-Rtime(1));
ntr=length(Rtime);
iRZdata=interp1(Rtime,RZdata,Ttime);

aTEdata=diff(TEdata)/dts;
aTNdata=diff(TNdata)/dts;
c0=5000;
 
% Quantify semblance between data
tmin=dts;itmin=round(tmin/dts);
tmax=14000;itmax=round(tmax/dts);

Ttime=Ttime(itmin:itmax);
nts=length(Ttime);
aTEdata=aTEdata(itmin:itmax);
aTNdata=aTNdata(itmin:itmax);
iRZdata=interp1(Rtime,RZdata,Ttime);

d=30; % = 10;% length of time window (s)
id=round(d/dts);
id2=round(id/2);

i=id2;
ii=1;
iang=0;


t1=4500;
t2=6500;
it1=round(t1/dts);
it2=round(t2/dts);

aTEdata(1:it1)=aTEdata(1:it1)*0;
aTNdata(1:it1)=aTNdata(1:it1)*0;
iRZdata(1:it1)=iRZdata(1:it1)*0;
aTEdata(it2:nts)=aTEdata(it2:nts)*0;
aTNdata(it2:nts)=aTNdata(it2:nts)*0;
iRZdata(it2:nts)=iRZdata(it2:nts)*0;

for T=5:5:100,
    
    disp(sprintf(' Upper period : %g s ',T))

    flow=.85*1/T;
    fup=1.15*1/T;
    
faTEdata=bandpass(aTEdata,dts,flow,fup,1);
faTNdata=bandpass(aTNdata,dts,flow,fup,1);
fiRZdata=bandpass(iRZdata,dts,flow,fup,1);
Tdata=-faTEdata*cos(34/180*pi)+faTNdata*sin(40/180*pi);


c=max(Tdata)/max(fiRZdata)

plot(Ttime,Tdata/c,'k-',Ttime,fiRZdata,'r-'),axis([t1 t2 -Inf Inf])


%plot(Ttime,aTEdata,'k-'),
title(sprintf(' T_{dom} = %g s; c_{phase} = %g m/s',T,c/2)),drawnow

end

pause



