
clear
clf

% Simple finite difference solver
%
% Acoustic wave equation  p_tt   = c^2 p_xx + src
%2-D regular grid


% Basic parameters

nt=1000;    % number of time steps
c0=1.;       % acoustic velocity
eps=1.;     % stability limit
isnap=10;


nx=500;     % number of grid points in x 
nz=nx;
p=zeros([nx nz]); pnew=p; pold=p; d2px=p; d2pz=p; 
c=p; c=c+c0;% initialization of pressure fields
dx=1./(nx-1);  % calculate space increment
x=(0:(nx-1))*dx; 
z=(0:(nz-1))*dx;  % initialize space coordinates
dt=.5*eps*dx/max(max(c)); % calculate tim step from stability criterion
 
% source time function

f0=1./(5.*dt);     					% dominant frequency
t=(1:nt)*dt; t0=4/f0;				% initialize time axis
src=exp(-f0^2*(t-t0).*(t-t0));	% source time function
src=diff(src);							% time derivative to obtain Gaussian


% Time stepping

for it=1:nt,
      
   % FD
   
   disp(sprintf(' Time step : %i',it));
   
   for j=2:nx-1,
      for k=2:nz-1,
         d2px(j,k)=(p(j+1,k)-2*p(j,k)+p(j-1,k))/dx^2; % space derivative 
         d2pz(j,k)=(p(j,k+1)-2*p(j,k)+p(j,k-1))/dx^2; % space derivative 
      end
   end
   pnew=2*p-pold+c.*c.*(d2px+d2pz)*dt^2;                % time extrapolation
   pnew(nx/4,nz/4)=pnew(nx/4,nz/4)+src(it)*dt^2;     % add source term
   pold=p;											% time levels
   p=pnew;
   
   if rem(it,isnap)== 0,
   % Display 
   imagesc(x,z,p), axis equal
   title(' FD ')
   drawnow
   end
end

   

