
clear
clf

% Simple finite difference solver
%
% Acoustic wave equation  p_tt   = c^2 p_xx + src
% 1-D regular grid


% Basic parameters

nt=1000;    % number of time steps
c=1.;       % acoustic velocity
eps=1.;     % stability limit


nx=250;     % number of grid points in x 
p=zeros([1 nx]); pnew=p; pold=p; d2p=p;   % initialization of pressure fields
dx=1./(nx-1);  % calculate space increment
x=(0:(nx-1))*dx; % initialize space coordinates
dt=.5*eps*dx/c; % calculate tim step from stability criterion
 
% source time function

f0=1./(10.*dt);     					% dominant frequency
t=(1:nt)*dt; t0=4/f0;				% initialize time axis
src=exp(-f0^2*(t-t0).*(t-t0));	% source time function
src=diff(src);							% time derivative to obtain Gaussian
src(nt+1)=0.;

% Time stepping

for i=1:nt,
      
   % FD
   
   disp(sprintf(' Time step : %i',i));
   
   for j=2:nx-1
      d2p(j)=(p(j+1)-2*p(j)+p(j-1))/dx^2; % space derivative 
   end
   pnew=2*p-pold+d2p*dt^2;                % time extrapolation
   pnew(nx/2)=pnew(nx/2)+src(i)*dt^2;     % add source term
   pold=p;											% time levels
   p=pnew;
   p(1)=0;											% set boundaries pressure free
   p(nx)=0;
   
   % Display 
   plot(x,p,'b-')
   title(' FD ')
   drawnow
end

   

